/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.java;

import ch.e2e.builder.compiler.build.types.addons.java.Options;
import ch.e2e.builder.compiler.build.types.addons.java.Shutdown;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.builder.compiler.build.types.tabfile.TextElement;
import ch.e2e.dom.DomUtilities;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class JavaVirtualMachine
extends RichElement {
    public static final String ELEMENT_NAME = "VirtualMachine";
    private Set<Shutdown> shutdowns = new LinkedHashSet<Shutdown>();
    private Options options;

    public JavaVirtualMachine() {
        this.setDefaults();
    }

    private void setDefaults() {
        this.setAttribute("killThreadsOnShutdown", "true");
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    private void killThreadsOnShutdown(boolean value) {
        this.setAttribute("killThreadsOnShutdown", String.valueOf(value));
    }

    private void addShutdown(Element tabfileElement) {
        this.shutdowns.add(new Shutdown(tabfileElement));
    }

    public void mergeIn(Element vmElement) {
        if (!DomUtilities.getBoolean((Element)vmElement, (String)"killThreadsOnShutdown", (boolean)true)) {
            this.killThreadsOnShutdown(false);
        }
        Iterator<Element> shutdownIterator = this.getElementIterator(vmElement, "Shutdown");
        while (shutdownIterator.hasNext()) {
            this.addShutdown(shutdownIterator.next());
        }
    }

    @Override
    protected void prepareChildren() {
        this.appendChild(new TextElement("ClassPath", "${ALIAS_VirtualMachine_ClassPath}"));
        this.appendChild(new TextElement("ParallelOperations", "${ALIAS_VirtualMachine_ParallelOperations}"));
        this.appendChildren(this.shutdowns);
        this.appendChild(this.options);
    }

    public void addOption(String option) {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.addOption(option);
    }
}

