/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import java.util.Objects;
import org.w3c.dom.Element;

public class RuntimeFeature {
    public static final String ELEMENT_NAME = "feature";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String RUNTIME_VERSION_ATTRIBUTE = "runtimeVersion";
    public static final String RUNTIME_VERSION_REQUIRED_ATTRIBUTE = "runtimeVersionRequired";
    private String description;
    private int runtimeVersionMajor;
    private int runtimeVersionMinor;
    private boolean isRuntimeVersionRequired;

    public RuntimeFeature(String description, int runtimeVersionMajor, int runtimeVersionMinor, boolean isRuntimeVersionRequired) {
        this.description = description;
        this.runtimeVersionMajor = runtimeVersionMajor;
        this.runtimeVersionMinor = runtimeVersionMinor;
        this.isRuntimeVersionRequired = isRuntimeVersionRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeFeature that = (RuntimeFeature)o;
        return this.runtimeVersionMajor == that.runtimeVersionMajor && this.runtimeVersionMinor == that.runtimeVersionMinor && this.isRuntimeVersionRequired == that.isRuntimeVersionRequired && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.runtimeVersionMajor, this.runtimeVersionMinor, this.isRuntimeVersionRequired);
    }

    public void serialize(Element parent) {
        Element feature = parent.getOwnerDocument().createElement(ELEMENT_NAME);
        feature.setAttribute(DESCRIPTION_ATTRIBUTE, this.description);
        feature.setAttribute(RUNTIME_VERSION_ATTRIBUTE, this.getRuntimeVersion());
        feature.setAttribute(RUNTIME_VERSION_REQUIRED_ATTRIBUTE, Boolean.toString(this.isRuntimeVersionRequired));
        parent.appendChild(feature);
    }

    public boolean isRuntimeVersionRequired() {
        return this.isRuntimeVersionRequired;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersionMajor + "." + this.runtimeVersionMinor;
    }

    public int versionCompare(RuntimeFeature rhs) {
        if (this.runtimeVersionMajor > rhs.runtimeVersionMajor) {
            return 1;
        }
        if (this.runtimeVersionMajor < rhs.runtimeVersionMajor) {
            return -1;
        }
        return this.runtimeVersionMinor - rhs.runtimeVersionMinor;
    }
}

