/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.errors.Error;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ErrorsTabfile
extends XmlTabfile {
    private Map<Error, Error> errors = new TreeMap<Error, Error>(new Comparator<Error>(){

        @Override
        public int compare(Error lhs, Error rhs) {
            return lhs.compareNames(rhs);
        }
    });

    public ErrorsTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element replaced = (Element)this.doReplace(table, configurationElement, compilableObject);
        Iterator errorIterator = DomUtilities.elementIterator((NodeList)replaced.getElementsByTagName("error"));
        while (errorIterator.hasNext()) {
            this.addError((Element)errorIterator.next());
        }
        return true;
    }

    private void addError(Element errorElement) {
        Error e = new Error(errorElement);
        Error existing = this.errors.get(e);
        if (existing != null) {
            existing.merge(e);
        } else {
            this.errors.put(e, e);
        }
    }

    @Override
    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        this.prepareDocument(library);
        super.beforeSerialize(zipOut, fileName, library);
    }

    void prepareDocument(boolean library) {
        this.setTabfileDocument(null);
        Document tabfile = this.getDocument();
        tabfile.getDocumentElement().removeAttribute("xmlns:xmi");
        for (Error e : this.errors.values()) {
            e.buildDom(tabfile.getDocumentElement(), library);
        }
    }
}

