/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AngularBuildException;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.CompilationProperties;
import ch.e2e.builder.compiler.build.tasks.NodeJsTask;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.rest.AngularException;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.rest.AngularProject;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.rest.AngularResult;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.library.LibraryContent;
import ch.e2e.builder.compiler.document.json.library.LibraryContentAngular;
import ch.e2e.builder.compiler.document.json.library.LibraryDescriptor;
import ch.e2e.builder.compiler.error.DefaultCompilerError;
import ch.e2e.builder.compiler.utils.EnvUtils;
import ch.e2e.builder.compiler.utils.StringUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public abstract class AngularBuildTask
extends NodeJsTask {
    private static final String ANGULAR_BUILD_TASK_XUML_ANGULAR_COMPILER_SERVICE_URL = "AngularBuildTask.xuml.angular.compiler.service.url";
    private static final ThreadPoolExecutor PARALLEL_TASK_THREAD_POOL = (ThreadPoolExecutor)Executors.newFixedThreadPool(EnvUtils.get("xuml_parallel_npm_task_number-of-threads", CompilationProperties.getInstance().getInt("xuml_parallel_npm_task_number-of-threads")));

    public AngularBuildTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    public boolean isUpToDate() {
        return super.isUpToDate() && this.getErrorHandler().getErrors().stream().allMatch(err -> err instanceof AngularBuildException);
    }

    @Override
    protected Set<String> getDestinationFiles() {
        HashSet<String> result = new HashSet<String>();
        Path distPath = this.getSourceManager().getWorkFolder().toPath().resolve(this.getDistFolder());
        if (distPath.toFile().exists()) {
            try (Stream<Path> pathStream = Files.walk(distPath, new FileVisitOption[0]);){
                pathStream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> result.add(this.getSourceManager().getWorkFolder().toPath().relativize((Path)path).toString()));
            }
            catch (IOException e) {
                this.getErrorHandler().error((Throwable)e);
            }
        }
        return result;
    }

    protected abstract String getDistFolder();

    @Override
    protected String getDestinationFileExtension() {
        return ".build.npm";
    }

    protected String getAngularProjectName() {
        return this.getDestinationFileNameWithoutExtension();
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> result = super.getBeforeSourceSet();
        result.addAll(this.getLibraryDescriptors());
        return result;
    }

    @Override
    protected Set<String> getSourcesToCheck() {
        HashSet<String> result = new HashSet<String>();
        this.getLibraryDescriptors().stream().filter(id -> Optional.ofNullable(((JsonDocumentSource)this.getSourceManager().getSource((String)id)).getJsonDocument(LibraryDescriptor.class)).map(LibraryDescriptor::getContent).map(LibraryContent::getAngular).map(LibraryContentAngular::getPackage).isPresent()).map(file -> "angular/" + Paths.get(file, new String[0]).getParent().getFileName().toString() + ".install.npm").forEach(result::add);
        result.add("angular/package.json");
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> getLibraryDescriptors() {
        try {
            Path libs = this.getSourceManager().getProjectFolder().toPath().resolve("libs/");
            try (Stream<Path> pathStream = Files.list(libs);){
                Set<String> set = pathStream.map(path -> path.getFileName().toString()).filter(filename -> filename.endsWith(".library.json")).map(filename -> ch.e2e.builder.compiler.build.tasks.constants.Files.libs_LIBRARY__library_descriptor_xml(filename.substring(0, filename.length() - ".library.json".length()))).collect(Collectors.toSet());
                return set;
            }
        }
        catch (Exception ignore) {
            return Collections.emptySet();
        }
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        Future<?> result = null;
        try {
            if (PARALLEL_TASK_THREAD_POOL.getQueue().size() > this.getMaxQueueSize()) {
                throw new BuildException("Parallel tasks queue size exceeded");
            }
            result = PARALLEL_TASK_THREAD_POOL.submit(() -> this.executeRestOperation(dependencyLevel));
            result.get(this.getTimeoutTime(), this.getTimeoutUnit());
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
            Optional.ofNullable(result).ifPresent(r -> r.cancel(true));
        }
    }

    @Override
    protected String getBaseUrl() {
        return EnvUtils.get(ANGULAR_BUILD_TASK_XUML_ANGULAR_COMPILER_SERVICE_URL, AngularBuildTask.getCompilationProperty(ANGULAR_BUILD_TASK_XUML_ANGULAR_COMPILER_SERVICE_URL));
    }

    @Override
    protected String getActionPath() {
        return "angular/build";
    }

    @Override
    protected Entity<?> getEntity() {
        String workspacePath = this.getSourceManager().getWorkFolder().toPath().resolve("angular").toAbsolutePath().toString();
        return Entity.json((Object)new AngularProject(workspacePath, this.getAngularProjectName()));
    }

    @Override
    protected void handleResponse(Response response) {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            AngularResult angularResult = (AngularResult)response.readEntity(AngularResult.class);
            this.log(StringUtils.filterUnprintableChars(angularResult.getOutput()));
        } else {
            AngularException angularException = (AngularException)response.readEntity(AngularException.class);
            String printableMessage = StringUtils.filterUnprintableChars(angularException.getMessage());
            this.logError(printableMessage);
            this.getErrorHandler().error((AbstractBuilderError)new AngularBuildException((Throwable)new BuildException(printableMessage)));
        }
    }

    @Override
    protected void handleError(Exception e) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("0", this.getAngularProjectName());
        parameters.put("1", e.getMessage());
        this.getErrorHandler().error((AbstractBuilderError)new DefaultCompilerError("ANGBUILD001", parameters));
        this.logError(e);
    }

    protected int getMaxQueueSize() {
        return EnvUtils.get("xuml_parallel_npm_task_max-queue-size", CompilationProperties.getInstance().getInt("xuml_parallel_npm_task_max-queue-size"));
    }

    protected int getTimeoutTime() {
        return EnvUtils.get("xuml_parallel_npm_task_timeout-time", CompilationProperties.getInstance().getInt("xuml_parallel_npm_task_timeout-time"));
    }

    protected TimeUnit getTimeoutUnit() {
        return TimeUnit.valueOf(EnvUtils.get("xuml_parallel_npm_task_timeout-unit", AngularBuildTask.getCompilationProperty("xuml_parallel_npm_task_timeout-unit")));
    }
}

