/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.base.message.SendStatusEvent;
import ch.e2e.builder.compiler.build.BuildErrorException;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.AfterXSLTTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.document.DependsFile;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.builder.compiler.error.DefaultCompilerWarning;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.logging.PerformanceLogger;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Xmi2ExmiAfterTask
extends AfterXSLTTask {
    private Document sourceDocument;
    private File dest;
    private static ArrayList<String> ignoredIncludes = new ArrayList();
    private List<String> idReftoReplace = Arrays.asList("type", "association", "context", "arrayElement", "signal", "postprocessor", "preprocessor", "realizingClassifier", "utilizedElement", "alias", "supplier", "general", "class", "behavior", "addition", "submachine", "source", "target", "event ", "specification", "operation", "contract", "externalStateDBAlias", "externalPropertiesStateDBAlias", "xsltScript", "template", "eventSource", "guardAttribute", "controller", "controllerURIAttribute", "httpUploadCall", "uploadSelectButton", "uploadSubmitButton", "onChange", "onComplete", "onSubmit", "allowedFileExtensionsErrorLabel", "regionAsInput", "regionAsOutput", "parameter", "callingService", "call", "callOnEntry", "callOnExit", "scriptCall", "scriptCallOnEntry", "scriptCallOnExit", "drawCallback", "onSignal", "throwSignal", "throwSignalOnEntry", "throwSignalOnExit", "errorPlacement", "components", "resource", "errorClass", "channel");

    @Override
    protected void propagateErrors() {
        super.propagateErrors();
        if (this.getUmlDocument() != null) {
            this.getErrorHandler().addTo((AbstractErrorHandler)this.getUmlDocument().getEXMIErrorHandler());
            this.getUmlDocument().getEXMIErrorHandler().serialize(false);
        }
    }

    public Document getSourceDocument() {
        return this.sourceDocument;
    }

    public void setSourceDocument(Document sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    public File getDest() {
        return this.dest;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        UmlDocument umlDocument = this.getUmlDocument();
        if (umlDocument == null) {
            throw new BuildException("UmlDocument not defined for task: " + this.getClass().getSimpleName());
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("document.name", umlDocument.getDocumentName());
        parameters.put("absolute path", umlDocument.getAbsolutePath());
        SendStatusEvent event = new SendStatusEvent((Object)this, "status.creating.bridge.xmi", parameters);
        EventController.fire((EventObject)event);
        try {
            Document sourceDocument = this.getSourceDocument();
            if (sourceDocument == null) {
                throw new BuildException("Unable to find source for compiler task: " + this.getClass().getSimpleName());
            }
            Document bridgeXmiDocument = this.createBridgeXmiDocument(sourceDocument);
            String version = this.getXmiVersion(bridgeXmiDocument);
            this.getUmlDocument().getDocumentInfo().setXmiVersion(version);
            this.getUmlDocument().getDocumentInfo().serialize();
            if (this.getDest() != null) {
                DomUtilities.serialize((File)this.getDest(), (Document)bridgeXmiDocument, (boolean)true);
            }
            DomUtilities.serialize((File)umlDocument.getBridgeXmiFile(), (Document)bridgeXmiDocument, (boolean)true);
            if (this.getErrorHandler().getFatalErrors().size() == 0) {
                umlDocument.setDescriptorIncluded(UmlDocument.isDescriptorIncluded(bridgeXmiDocument));
            }
        }
        catch (TransformerException ex) {
            throw new BuildException(ex);
        }
        catch (BuildErrorException beEx) {
            throw beEx;
        }
        catch (Exception ex) {
            this.showFatalError(ex.getMessage() == null ? "null" : ex.getMessage());
            throw new BuildException(ex);
        }
        finally {
            umlDocument.resetLastModified();
        }
    }

    private Document createBridgeXmiDocument(Document bridgeXmiDocument) throws TransformerException, IOException, XPathExpressionException {
        this.getUmlDocument().getDocumentInfo().setLibraryImportDocument(bridgeXmiDocument.hasChildNodes() && DomUtilities.getBoolean((Element)bridgeXmiDocument.getDocumentElement(), (String)"libraryImport", (boolean)false));
        return this.createBridgeXmiFile(bridgeXmiDocument);
    }

    private String getXmiVersion(Document xmlDocument) {
        String version = null;
        Element root = xmlDocument.getDocumentElement();
        if (root.hasAttribute("xmi.version")) {
            version = root.getAttribute("xmi.version");
        } else if (root.hasAttribute("xmi:version")) {
            version = root.getAttribute("xmi:version");
        }
        if (version == null) {
            version = "2.1";
            root.setAttribute("xmi:version", version);
        }
        return version;
    }

    private Document createBridgeXmiFile(Document bridgeXmiDocument) throws IOException, TransformerException, XPathExpressionException {
        long start = PerformanceLogger.start((String)(this.getClass().getSimpleName() + ".createBridgeXmiFile"), (String)this.getUmlDocument().getName());
        DependsFile dependsFile = this.getUmlDocument().getDocumentInfo().getDependsFile();
        dependsFile.clear();
        dependsFile.setDependingOnBaseZip(DomUtilities.getBoolean((Element)bridgeXmiDocument.getDocumentElement(), (String)"dependingOnBaseZip", (boolean)false));
        if (bridgeXmiDocument.getDocumentElement() != null) {
            int i;
            bridgeXmiDocument.getDocumentElement().setAttribute("xmifile.id", this.getUmlDocument().getUniqueId());
            HashMap<String, String> includes = this.createDependencies(bridgeXmiDocument, this.getUmlDocument().getOriginalFile().getParentFile(), dependsFile);
            ArrayList<String> unusableIncludes = new ArrayList<String>(ignoredIncludes);
            unusableIncludes.add(this.getUmlDocument().getOriginalFile().getName());
            ArrayList<Element> childrenToRemove = new ArrayList<Element>();
            XPath xpath = DomUtilities.newXPath();
            NodeList attributes = (NodeList)xpath.evaluate("//@href", bridgeXmiDocument.getDocumentElement(), XPathConstants.NODESET);
            int length = attributes.getLength();
            for (i = 0; i < length; ++i) {
                this.replaceHref(((Attr)attributes.item(i)).getOwnerElement(), includes, dependsFile, childrenToRemove, unusableIncludes);
            }
            attributes = (NodeList)DomUtilities.evaluate((Node)bridgeXmiDocument.getDocumentElement(), (String)"//@xmi:idref", (QName)XPathConstants.NODESET);
            length = attributes.getLength();
            for (i = 0; i < length; ++i) {
                this.replaceIdref(((Attr)attributes.item(i)).getOwnerElement(), childrenToRemove);
            }
            for (Element element : childrenToRemove) {
                element.getParentNode().removeChild(element);
            }
            dependsFile.addIncludesFile(this.getUmlDocumentFactory().getBridgeProfileDocument());
            for (String filename : includes.values()) {
                UmlDocument document = this.getUmlDocumentFactory().getUmlDocument(filename);
                if (document == null) continue;
                dependsFile.addMountedDocument(document);
            }
        }
        PerformanceLogger.stop((String)(this.getClass().getSimpleName() + ".createBridgeXmiFile"), (String)this.getUmlDocument().getName(), (long)start);
        return bridgeXmiDocument;
    }

    private void replaceHref(Element child, HashMap<String, String> includes, DependsFile dependsFile, ArrayList<Element> childrenToRemove, ArrayList<String> unusableIncludes) {
        String localName;
        String file;
        String href = child.getAttribute("href");
        int index = href.lastIndexOf(35);
        if (index != -1 && !unusableIncludes.contains(file = href.substring(0, index))) {
            String absolutePath = file.contains("E2E Bridge Base") ? (this.getUmlDocumentFactory().getBridgeBaseDocument() == null ? null : this.getUmlDocumentFactory().getBridgeBaseDocument().getAbsolutePath()) : (file.contains("E2E Bridge Profile") ? (this.getUmlDocumentFactory().getBridgeProfileDocument() == null ? null : this.getUmlDocumentFactory().getBridgeProfileDocument().getAbsolutePath()) : (file.contains("E2E Process Tracing") ? (this.getUmlDocumentFactory().getProcessTracingDocument() == null ? null : this.getUmlDocumentFactory().getProcessTracingDocument().getAbsolutePath()) : includes.get(file)));
            if (absolutePath == null) {
                this.addIncludesFileNotFound(unusableIncludes, file);
            } else {
                UmlDocument document = this.getUmlDocumentFactory().getUmlDocument(absolutePath);
                if (document == null) {
                    this.addIncludesFileNotFound(unusableIncludes, file);
                } else {
                    String id = href.substring(index + 1);
                    href = document.getUniqueId() + '|' + id;
                    dependsFile.getIncludesFile(document).addXmiElementID(href);
                }
            }
        }
        Element parent = (Element)child.getParentNode();
        String string = localName = child.getLocalName() != null ? child.getLocalName() : child.getNodeName();
        if (parent.hasAttribute(localName)) {
            parent.setAttribute(localName, parent.getAttribute(localName) + " " + href);
        } else {
            parent.setAttribute(localName, href);
        }
        childrenToRemove.add(child);
    }

    private void replaceIdref(Element child, ArrayList<Element> childrenToRemove) {
        String localName;
        String string = localName = child.getLocalName() != null ? child.getLocalName() : child.getNodeName();
        if (this.idReftoReplace.contains(localName)) {
            String idref = child.getAttribute("xmi:idref");
            Element parent = (Element)child.getParentNode();
            if (!parent.hasAttribute(localName)) {
                parent.setAttribute(localName, idref);
            }
            childrenToRemove.add(child);
        }
    }

    private void addIncludesFileNotFound(ArrayList<String> unusableIncludes, String file) {
        Logging.logger.warning("Could not find includes file '" + file + "'.");
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("name", file);
        this.getErrorHandler().warning((BuilderWarning)new DefaultCompilerWarning("xslt.error.missing.include", errorMap));
        unusableIncludes.add(file);
    }

    private HashMap<String, String> createDependencies(Document resultDoc, File parentFolder, DependsFile dependsFile) {
        HashMap<String, String> includes = new HashMap<String, String>();
        Element root = resultDoc.getDocumentElement();
        NodeList dependenciesList = root.getElementsByTagName("dependencies");
        if (dependenciesList != null && dependenciesList.getLength() == 1) {
            Element listElement = (Element)dependenciesList.item(0);
            NodeList paths = listElement.getElementsByTagName("dependencypath");
            File[] dependencyPaths = this.readDependencyPaths(parentFolder, paths);
            NodeList resources = listElement.getElementsByTagName("resource");
            this.readDependingFiles(resources, dependencyPaths, includes);
            root.removeChild(listElement);
            NodeList includesList = listElement.getElementsByTagName("include");
            if (includesList != null && includesList.getLength() > 0) {
                int length = includesList.getLength();
                for (int i = 0; i < length; ++i) {
                    Element includeElement = (Element)includesList.item(i);
                    String includeFile = includeElement.getAttribute("file");
                    File file = new File(includeFile);
                    if (file.isAbsolute()) {
                        file = this.findDependingFile(new File(includeFile), dependencyPaths);
                    } else {
                        File srcFolder = this.getUmlDocument().getSettings().getUmlSourceFolder();
                        file = this.findDependingFile(new File(srcFolder, includeFile), dependencyPaths);
                    }
                    if (file == null) continue;
                    long start = PerformanceLogger.start((String)(this.getClass().getSimpleName() + ".addIncludesFile"), (String)this.getUmlDocument().getName());
                    UmlDocumentFactory factory = this.getUmlDocumentFactory();
                    UmlDocument document = factory.getUmlDocument(file);
                    dependsFile.addIncludesFile(document);
                    PerformanceLogger.stop((String)(this.getClass().getSimpleName() + ".addIncludesFile"), (String)this.getUmlDocument().getName(), (long)start);
                }
            }
        }
        return includes;
    }

    static File getFileFromURL(String url) throws MalformedURLException, URISyntaxException {
        try {
            url = new URL(url).toString();
        }
        catch (MalformedURLException e) {
            url = "file:/" + url;
        }
        if (url.contains("%3C") && url.indexOf("%3E") > url.indexOf("%3C")) {
            url = CompilerConstants.replaceURIProperties(url, System.getProperties());
        }
        URI uri = new URI(url);
        return new File(uri);
    }

    private void readDependingFiles(NodeList resources, File[] dependencyPaths, HashMap<String, String> includes) {
        int length = resources.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = (Element)resources.item(i);
            try {
                File includesFile = Xmi2ExmiAfterTask.getFileFromURL(element.getAttribute("url"));
                String includesName = includesFile.getName();
                if (includes.containsKey(includesName)) continue;
                if (includesName.equals("E2E Bridge Base")) {
                    if (this.getUmlDocumentFactory().getBridgeBaseDocument() != null) {
                        includes.put(includesName, this.getUmlDocumentFactory().getBridgeBaseDocument().getAbsolutePath());
                        continue;
                    }
                    if (!includesFile.exists()) continue;
                    includes.put(includesName, FileUtilities.getAbsolutePath((File)includesFile));
                    continue;
                }
                if (includesName.equals("E2E Bridge Profile")) {
                    if (this.getUmlDocumentFactory().getBridgeProfileDocument() != null) {
                        includes.put(includesName, this.getUmlDocumentFactory().getBridgeProfileDocument().getAbsolutePath());
                        continue;
                    }
                    if (!includesFile.exists()) continue;
                    includes.put(includesName, FileUtilities.getAbsolutePath((File)includesFile));
                    continue;
                }
                if (includesName.equals("E2E Process Tracing.xml")) {
                    if (this.getUmlDocumentFactory().getProcessTracingDocument() != null) {
                        includes.put(includesName, this.getUmlDocumentFactory().getProcessTracingDocument().getAbsolutePath());
                        continue;
                    }
                    if (!includesFile.exists()) continue;
                    includes.put(includesName, FileUtilities.getAbsolutePath((File)includesFile));
                    continue;
                }
                if (includesFile.exists()) {
                    includes.put(includesName, FileUtilities.getAbsolutePath((File)includesFile));
                    continue;
                }
                long start = PerformanceLogger.start((String)(this.getClass().getSimpleName() + ".findDependingFile"), (String)includesName);
                File dependingFile = this.findDependingFile(includesFile, dependencyPaths);
                PerformanceLogger.stop((String)(this.getClass().getSimpleName() + ".findDependingFile"), (String)includesName, (long)start);
                if (dependingFile == null) continue;
                includes.put(dependingFile.getName(), FileUtilities.getAbsolutePath((File)dependingFile));
                continue;
            }
            catch (Exception e) {
                Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                Logging.logger.throwing(this.getClass().getName(), "readResourceURLs", e);
            }
        }
    }

    private File findDependingFile(File includesFile, File[] dependencyPaths) {
        File result = null;
        String filename = includesFile.getName();
        for (int j = 0; j < dependencyPaths.length && !includesFile.exists(); ++j) {
            includesFile = new File(dependencyPaths[j], filename);
        }
        if (includesFile.exists()) {
            result = includesFile;
        }
        return result;
    }

    private File[] readDependencyPaths(File parentFolder, NodeList paths) {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(parentFolder);
        int length = paths.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = (Element)paths.item(i);
            String dir = element.getAttribute("dir");
            HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
            props.put("project.dir", this.getUmlDocument().getOriginalFile().getParentFile().getAbsolutePath());
            dir = StringTools.replaceProperties((String)dir, props, (String)"<", (String)">");
            dir = dir.replace('\\', '/');
            File folder = new File(dir);
            if (!folder.exists() || dirs.contains(folder)) continue;
            dirs.add(folder);
        }
        File srcFolder = this.getUmlDocument().getSettings().getUmlSourceFolder();
        if (!parentFolder.equals(srcFolder) && !dirs.contains(srcFolder)) {
            dirs.add(srcFolder);
        }
        File[] dependencyPaths = new File[dirs.size()];
        dirs.toArray(dependencyPaths);
        return dependencyPaths;
    }

    @Override
    void setSource(Document source) {
        this.sourceDocument = source;
    }

    @Override
    long getResultLastModified() {
        if (this.getDest() != null) {
            return this.getDest().lastModified();
        }
        if (this.getUmlDocument() != null) {
            return this.getUmlDocument().getBridgeXmiFile().lastModified();
        }
        return 0L;
    }

    static {
        ignoredIncludes.add("http://schema.omg.org/spec/UML/2.0/uml.xml");
        ignoredIncludes.add("http://www.omg.org/spec/UML/20090901/uml.xml");
        ignoredIncludes.add("http://www.omg.org/spec/UML/20131001/PrimitiveTypes.xmi");
    }
}

