/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.FileInputField;
import ch.e2e.builder.base.io.FileService;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.ProjectConstants;
import ch.e2e.builder.base.project.gui.Logging;
import ch.e2e.builder.base.resource.Buttons;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.io.FileUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class ProjectWizardPanel
extends JPanel
implements ProjectConstants,
Buttons,
Logging {
    private ArrayList<File> createdFolders = new ArrayList();
    private ArrayList<FileInputField> folderFields = new ArrayList();
    public static final String folderInputPanelBrowseButtonName = ProjectWizardPanel.class.toString() + ".folderInputPanelBrowseButton";

    protected ProjectWizardPanel() {
    }

    public void doOnOk() {
        int length = this.folderFields.size();
        for (int i = 0; i < length; ++i) {
            FileInputField inputField = this.folderFields.get(i);
            File file = inputField.getContent();
            if (!file.exists()) {
                file.mkdirs();
            }
            this.createdFolders.remove(file);
        }
        this.deleteCreatedFolders();
    }

    public void doOnCancel() {
        this.deleteCreatedFolders();
    }

    private void deleteCreatedFolders() {
        for (File file : this.createdFolders) {
            if (!file.exists() || FileUtilities.containsFiles((File)file)) continue;
            try {
                FileUtilities.deleteDirectory((File)file);
            }
            catch (IOException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "deleteCreatedFolders", e);
            }
        }
        this.createdFolders.clear();
    }

    abstract void fillProjectInfo(E2EBuilderProject var1);

    protected FileInputField createFolderInput(JLabel label, String title, String subtitle, JPanel panel, GridBagConstraints c, boolean last) {
        BrowseAction action = new BrowseAction(title, subtitle);
        return this.createFolderInput(label, panel, c, action, last);
    }

    protected FileInputField createFolderInput(JLabel label, JPanel panel, GridBagConstraints c, BrowseAction action, boolean last) {
        JPanel folderInputPanel = new JPanel(new BorderLayout(5, 0));
        folderInputPanel.add((Component)label, "West");
        FileInputField folderField = new FileInputField();
        this.folderFields.add(folderField);
        folderField.setEditable(false);
        folderInputPanel.add((Component)((Object)folderField), "Center");
        JButton browse = ComponentFactory.createButton("button.browse", (String)null);
        browse.setName(folderInputPanelBrowseButtonName);
        folderInputPanel.add((Component)browse, "East");
        if (last) {
            c.weighty = 1.0;
        }
        c.weightx = 1.0;
        c.gridwidth = 0;
        panel.add((Component)folderInputPanel, c);
        action.folderField = folderField;
        browse.addActionListener(action);
        return folderField;
    }

    protected String getTranslation(String key) {
        return E2EBuilderTranslator.getTranslation((String)key, (String)key);
    }

    protected String getModuleTranslation(String module, String key) {
        return E2EBuilderTranslator.getModuleTranslation((String)module, (String)key, (String)key);
    }

    protected class BrowseAction
    implements ActionListener {
        private FileInputField folderField;
        private String title;
        private String subtitle;

        protected BrowseAction(String title, String subtitle) {
            this.title = title;
            this.subtitle = subtitle;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            File startDir = new File(this.folderField.getText());
            this.createFolders(startDir);
            File folder = this.selectFolder(startDir, this.title, this.subtitle);
            if (folder != null) {
                this.folderField.setContent(folder);
            }
            int length = ProjectWizardPanel.this.createdFolders.size();
            for (int i = length - 1; i > -1; --i) {
                File file = (File)ProjectWizardPanel.this.createdFolders.get(i);
                file.delete();
            }
        }

        public File selectFolder(File startDir, String title, String subtitle) {
            return FileService.selectFolder(startDir, title, subtitle);
        }

        private void createFolders(File startDir) {
            for (File parent = startDir; parent != null && !parent.exists(); parent = parent.getParentFile()) {
                ProjectWizardPanel.this.createdFolders.add(parent);
            }
            if (startDir != null && !startDir.exists()) {
                startDir.mkdirs();
            }
        }
    }
}

