/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.gui.NewPropertyDialog;
import ch.e2e.builder.base.gui.Property;
import ch.e2e.builder.base.gui.ResourceTableModel;
import ch.e2e.builder.base.gui.StringConstants;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.resource.Properties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ResourceEditor
extends E2EBuilderDialog
implements StringConstants {
    private static ResourceEditor editor;
    private static String defaultTitle;
    private static String defaultInternaltitle;
    private static String defaultSubtitle;
    private JTable resourceTable;
    private ResourceTableModel resourceTableModel;
    private JButton remove;

    public ResourceEditor() {
        super(defaultTitle, defaultInternaltitle, defaultSubtitle, 3);
        this.createGui();
    }

    public static boolean editResources(Map<Object, Object> properties) {
        return ResourceEditor.editResources(properties, defaultTitle, defaultInternaltitle, defaultSubtitle);
    }

    public static boolean editResources(Map<Object, Object> properties, String title, String internalTitle, String subtitle) {
        if (editor == null) {
            editor = new ResourceEditor();
        }
        editor.setTitles(title, internalTitle, subtitle);
        return editor.editProperties(properties);
    }

    public static void editResources(File resourceFile) throws IOException {
        ResourceEditor.editResources(resourceFile, defaultTitle, defaultInternaltitle, defaultSubtitle);
    }

    public static boolean editResources(File resourceFile, String title, String internalTitle, String subtitle) throws IOException {
        boolean result = false;
        if (editor == null) {
            editor = new ResourceEditor();
        }
        editor.setTitles(title, internalTitle, subtitle);
        Properties properties = new Properties(resourceFile);
        if (editor.editProperties((Map<Object, Object>)properties)) {
            editor.saveProperties(properties);
            result = true;
        }
        return result;
    }

    private void setTitles(String title, String internalTitle, String subtitle) {
        this.setTitle(title);
        this.setInternalTitle(internalTitle);
        this.setSubtitle(subtitle);
    }

    private boolean editProperties(Map<Object, Object> properties) {
        this.resourceTableModel.setProperties(properties);
        return this.showDialog() == 1;
    }

    private void saveProperties(Properties properties) throws IOException {
        int i;
        List<Property> propertyList = this.resourceTableModel.getProperties();
        ArrayList names = new ArrayList();
        Iterator keys = properties.keySet().iterator();
        while (keys.hasNext()) {
            names.add(keys.next());
        }
        int length = propertyList.size();
        for (i = 0; i < length; ++i) {
            Property property = propertyList.get(i);
            names.remove(property.getKey());
            properties.setProperty(property.getKey(), property.getValue());
        }
        length = names.size();
        for (i = 0; i < length; ++i) {
            String key = (String)names.get(i);
            properties.removeProperty(key);
        }
        properties.write(false);
    }

    public int getMinimumHeight() {
        return 400;
    }

    public int getMinimumWidth() {
        return 500;
    }

    private void createGui() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.initializeTable();
        this.resourceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ResourceEditor.this.checkRemoveButton();
            }
        });
        this.add(new JScrollPane(this.resourceTable), "Center");
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 5, 0, 0);
        c.fill = 2;
        c.anchor = 11;
        c.gridwidth = 0;
        c.weighty = 0.0;
        JButton add = new JButton(E2EBuilderTranslator.getTranslation((String)"resource.editor.button.add"));
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceEditor.this.addProperty();
            }
        });
        buttonPanel.add((Component)add, c);
        this.remove = new JButton(E2EBuilderTranslator.getTranslation((String)"resource.editor.button.remove"));
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceEditor.this.removeProperty();
            }
        });
        c.weighty = 1.0;
        buttonPanel.add((Component)this.remove, c);
        this.add(buttonPanel, "East");
    }

    private void initializeTable() {
        this.resourceTableModel = new ResourceTableModel();
        this.resourceTable = new JTable(this.resourceTableModel);
    }

    private void checkRemoveButton() {
        int[] selectedRows = this.resourceTable.getSelectedRows();
        boolean enabled = selectedRows.length > 0;
        this.remove.setEnabled(enabled);
    }

    private void removeProperty() {
        int[] selectedRows = this.resourceTable.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            this.resourceTableModel.removeRow(selectedRows[i]);
        }
    }

    private void addProperty() {
        Property property = NewPropertyDialog.createNewProperty();
        if (property != null) {
            this.resourceTableModel.addProperty(property);
        }
    }

    static {
        defaultTitle = E2EBuilderTranslator.getTranslation((String)"resource.editor.title");
        defaultInternaltitle = E2EBuilderTranslator.getTranslation((String)"resource.editor.internaltitle");
        defaultSubtitle = E2EBuilderTranslator.getTranslation((String)"resource.editor.subtitle");
    }
}

