/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.base.io.FileService;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.InputTextField;
import com.jidesoft.swing.JideButton;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class E2EBuilderFileOrURLDialog
extends E2EBuilderDialog {
    private static final String FILE_CHOOSER_BUTTON = "wsdl.import.dialog.file.chooser.button";
    private static final String URL_TOOLTIP = "wsdl.import.dialog.url.tooltip";
    private static final String FILE_CHOOSER_TOOLTIP = "wsdl.import.dialog.file.chooser.tooltip";
    private InputTextField urlItem;
    private URL defaultUrl;
    private String fileChooserTitle;
    private String fileChooserSubtitle;
    private E2EFileFilter[] fileFilter;

    public E2EBuilderFileOrURLDialog(String title, String internalTitle, String subtitle, String fileChooserTitle, String fileChooserSubtitle, String url, E2EFileFilter[] fileFilter) {
        super(title, internalTitle, subtitle, 3);
        this.fileChooserTitle = fileChooserTitle;
        this.fileChooserSubtitle = fileChooserSubtitle;
        this.fileFilter = fileFilter;
        this.createGUI(url);
    }

    public URL getUrl() throws MalformedURLException {
        File file = new File(this.urlItem.getText());
        return file.canRead() ? file.toURI().toURL() : new URL(this.urlItem.getText());
    }

    public File getFile() {
        File file = new File(this.urlItem.getText());
        return file.canRead() ? file : null;
    }

    @Override
    public int showDialog() {
        String url = this.urlItem.getText();
        this.setOkButtonEnabled(url != null);
        this.urlItem.setContent((Object)url);
        try {
            this.defaultUrl = url == null || url.isEmpty() ? new File(System.getProperty("ch.e2e.builder.base.repository")).toURI().toURL() : new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return super.showDialog();
    }

    private void createGUI(String url) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridwidth = 0;
        c.insets = new Insets(5, 0, 5, 0);
        panel.add((Component)this.urlComponent(url), c);
        this.add(panel, "Before");
    }

    private JComponent urlComponent(String url) {
        JPanel urlPanel = new JPanel(new FlowLayout(3, 0, 0));
        this.urlItem = new InputTextField(50);
        this.urlItem.setText(url);
        this.urlItem.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                String url = E2EBuilderFileOrURLDialog.this.urlItem.getText();
                E2EBuilderFileOrURLDialog.this.setOkButtonEnabled(url != null && !url.isEmpty());
            }
        });
        urlPanel.add((Component)this.urlItem);
        urlPanel.add((Component)((Object)new ChooserButton(E2EBuilderTranslator.getTranslation((String)FILE_CHOOSER_BUTTON, (String)"..."))));
        urlPanel.setToolTipText(E2EBuilderTranslator.getTranslation((String)URL_TOOLTIP));
        return urlPanel;
    }

    private class ChooserButton
    extends JideButton {
        private ChooserButton(String text) {
            super(text);
            this.setOpaque(true);
            this.setRolloverEnabled(false);
            this.setToolTipText(E2EBuilderTranslator.getTranslation((String)E2EBuilderFileOrURLDialog.FILE_CHOOSER_TOOLTIP));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    File defaultFile = null;
                    if (E2EBuilderFileOrURLDialog.this.defaultUrl != null && "file".equals(E2EBuilderFileOrURLDialog.this.defaultUrl.getProtocol())) {
                        try {
                            defaultFile = new File(E2EBuilderFileOrURLDialog.this.defaultUrl.toURI());
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    } else {
                        defaultFile = new File(System.getProperty("ch.e2e.builder.base.repository"));
                    }
                    if ((file = FileService.selectFile(defaultFile, E2EBuilderFileOrURLDialog.this.fileFilter, E2EBuilderFileOrURLDialog.this.fileChooserTitle, E2EBuilderFileOrURLDialog.this.fileChooserSubtitle)) != null) {
                        E2EBuilderFileOrURLDialog.this.urlItem.setContent((Object)file.getPath());
                        try {
                            E2EBuilderFileOrURLDialog.this.defaultUrl = file.toURI().toURL();
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }
}

