/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.application.ParentApplication;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderInfo;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.module.ModuleInfo;
import ch.e2e.builder.base.module.XSLTToolsInfo;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.event.EventExecuter;
import ch.e2e.util.StringTools;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class AboutBox
extends E2EBuilderDialog
implements EventExecuter {
    private String applicationInfo;
    private String runtimeVersion;

    public AboutBox(ParentApplication parentApplication) {
        super(parentApplication.getApplicationFrame(), "", "", "", 1);
        String subtitle;
        this.applicationInfo = parentApplication.getDisplayName() + ' ' + parentApplication.getVersion();
        String title = E2EBuilderTranslator.getTranslation((String)"about.application.title");
        title = StringTools.replaceProperty((String)title, (String)"application.name", (String)parentApplication.getApplicationInfo().getTitle());
        this.setTitle(title);
        String internalTitle = E2EBuilderTranslator.getTranslation((String)"about.application.internaltitle");
        if (internalTitle != null) {
            internalTitle = StringTools.replaceProperty((String)internalTitle, (String)"application.name", (String)parentApplication.getDisplayName());
            internalTitle = StringTools.replaceProperty((String)internalTitle, (String)"application.version", (String)parentApplication.getVersion());
            internalTitle = StringTools.replaceProperty((String)internalTitle, (String)"application.build.date", (String)parentApplication.getBuildDate());
            this.setInternalTitle(internalTitle);
        }
        if ((subtitle = E2EBuilderTranslator.getTranslation((String)"about.application.subtitle")) != null) {
            subtitle = StringTools.replaceProperty((String)subtitle, (String)"application.name", (String)parentApplication.getApplicationInfo().getTitle());
            this.setSubtitle(subtitle);
        }
        this.addEventHandler();
        this.createGui(parentApplication);
    }

    public void execute(EventObject event) {
        this.showAboutBox();
    }

    protected void addEventHandler() {
    }

    public void showAboutBox() {
        this.showModuleInfo();
    }

    protected void showModuleInfo() {
        this.showDialog();
    }

    private void createGui(final ParentApplication parentApplication) {
        this.setLayout(new BorderLayout());
        JideTabbedPane contentPane = new JideTabbedPane();
        this.add((Component)contentPane, "Center");
        this.addModulePanel(contentPane, parentApplication.getBaseInfo(), "application.name");
        for (E2EBuilderModule module : parentApplication.getModuleFactory().getModules()) {
            this.addModulePanel(contentPane, module.getModuleInfo(), "module.name");
        }
        JButton copyButton = ComponentFactory.createButton("about.button.copy.to.clipboard", (String)null);
        this.addButton(copyButton, 2);
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutBox.this.copyToClipBoard(parentApplication.getModuleFactory().getModules(), null);
            }
        });
    }

    private void addModulePanel(JideTabbedPane contentPane, ModuleInfo info, String titleLabelKey) {
        JPanel modulePanel = new JPanel(new BorderLayout(2, 2));
        modulePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        JPanel centerPanel = new JPanel(new GridBagLayout());
        this.addPluginPanel(info, centerPanel, c);
        c.fill = 1;
        this.addModulePanel(info, titleLabelKey, centerPanel, c, 1.0);
        modulePanel.add((Component)centerPanel, "Center");
        contentPane.addTab(info.getShorttitle(), (Component)modulePanel);
    }

    private void addModulePanel(ModuleInfo info, String titleLabelKey, JPanel parentPanel, GridBagConstraints c, double weighty) {
        E2EBuilderInfo builderInfo;
        JPanel infoPanel = new JPanel(new GridBagLayout());
        JLabel nameLabel = ComponentFactory.createLabel(titleLabelKey);
        JLabel applicationName = ComponentFactory.createLabel(info.getTitle() == null ? "" : info.getTitle());
        this.addRow(nameLabel, applicationName, infoPanel, c);
        JLabel version = ComponentFactory.createLabel(info.getVersion() == null ? "" : info.getVersion());
        this.addRow("version", version, infoPanel, c);
        JLabel date = ComponentFactory.createLabel(info.getDate() == null ? "" : info.getDate());
        this.addRow("date", date, infoPanel, c);
        JLabel vendor = ComponentFactory.createLabel(info.getVendor() == null ? "" : info.getVendor());
        this.addRow("vendor", vendor, infoPanel, c);
        JLabel copyright = ComponentFactory.createLabel(info.getCopyright() == null ? "" : info.getCopyright());
        this.addRow("copyright", copyright, infoPanel, c);
        if (info instanceof E2EBuilderInfo && (builderInfo = (E2EBuilderInfo)info).getRuntimeVersion() != null && builderInfo.getRuntimeVersion().length() > 0) {
            JLabel runtime = ComponentFactory.createLabel(builderInfo.getRuntimeVersion());
            this.addRow("runtime.version", runtime, infoPanel, c);
            this.runtimeVersion = builderInfo.getRuntimeVersion();
        }
        c.fill = 2;
        c.weighty = weighty;
        c.gridwidth = 0;
        parentPanel.add((Component)infoPanel, c);
        CompoundBorder infoPanelBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(3, 3, 3, 3));
        infoPanel.setBorder(infoPanelBorder);
    }

    private void addPluginPanel(ModuleInfo info, JPanel centerPanel, GridBagConstraints c) {
        if (info.containsPluginInfo()) {
            JPanel pluginPanel = new JPanel(new GridBagLayout());
            JLabel pluginName = ComponentFactory.createLabel(info.getPluginTitle() == null ? "" : info.getPluginTitle());
            this.addRow("plugin.name", pluginName, pluginPanel, c);
            JLabel pluginVersion = ComponentFactory.createLabel(info.getPluginVersion() == null ? "" : info.getPluginVersion());
            this.addRow("version", pluginVersion, pluginPanel, c);
            JLabel pluginDate = ComponentFactory.createLabel(info.getPluginDate() == null ? "" : info.getPluginDate());
            this.addRow("date", pluginDate, pluginPanel, c);
            JLabel pluginVendor = ComponentFactory.createLabel(info.getPluginVendor() == null ? "" : info.getPluginVendor());
            this.addRow("vendor", pluginVendor, pluginPanel, c);
            JLabel pluginCopyright = ComponentFactory.createLabel(info.getCopyright() == null ? "" : info.getPluginCopyright());
            this.addRow("copyright", pluginCopyright, pluginPanel, c);
            pluginPanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(3, 3, 3, 3)));
            c.fill = 2;
            c.weighty = 0.0;
            c.gridwidth = 0;
            centerPanel.add((Component)pluginPanel, c);
        }
    }

    private void addXSLTInfo(JideTabbedPane contentPane, XSLTToolsInfo toolsInfo) {
        JPanel xsltInfo = new JPanel(new GridBagLayout());
        xsltInfo.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.weighty = 0.0;
        this.addModulePanel(toolsInfo, "module.name", xsltInfo, c, 0.0);
        JTextPane infoArea = new JTextPane();
        this.fillXSLTInfos(infoArea, toolsInfo);
        infoArea.setOpaque(false);
        infoArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(infoArea, 20, 30);
        scrollPane.setOpaque(false);
        scrollPane.setPreferredSize(new Dimension(40, 40));
        c.fill = 1;
        c.weighty = 1.0;
        xsltInfo.add((Component)scrollPane, c);
        contentPane.add(E2EBuilderTranslator.getTranslation((String)"xslt.info.title"), (Component)xsltInfo);
    }

    private void fillXSLTInfos(JTextPane infoArea, XSLTToolsInfo toolsInfo) {
        StyleContext context = new StyleContext();
        Style def = context.getStyle("default");
        Style title = context.addStyle("info.title", def);
        StyleConstants.setFontFamily(title, "SansSerif");
        StyleConstants.setFontSize(title, 12);
        StyleConstants.setBold(title, true);
        StyleConstants.setAlignment(title, 0);
        Style info = context.addStyle("info.info", def);
        StyleConstants.setFontFamily(info, "SansSerif");
        StyleConstants.setFontSize(info, 12);
        StyleConstants.setBold(info, false);
        StyleConstants.setAlignment(info, 0);
        for (int i = 0; i < toolsInfo.getXsltToolsModules().length; ++i) {
            try {
                int offset = infoArea.getDocument().getLength();
                infoArea.getDocument().insertString(offset, toolsInfo.getXsltToolsModules()[i].getTitle() + '\n', title);
                offset = infoArea.getDocument().getLength();
                infoArea.getDocument().insertString(offset, E2EBuilderTranslator.getTranslation((String)"version") + ": " + toolsInfo.getXsltToolsModules()[i].getVersion() + '\n', info);
                offset = infoArea.getDocument().getLength();
                infoArea.getDocument().insertString(offset, E2EBuilderTranslator.getTranslation((String)"date") + ": " + toolsInfo.getXsltToolsModules()[i].getDate(), info);
                if (i >= toolsInfo.getXsltToolsModules().length - 1) continue;
                offset = infoArea.getDocument().getLength();
                infoArea.getDocument().insertString(offset, "\n\n", info);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        infoArea.setCaretPosition(0);
    }

    private void addRow(String nameKey, JLabel value, JPanel panel, GridBagConstraints c) {
        this.addRow(ComponentFactory.createLabel(nameKey), value, panel, c);
    }

    private void addRow(JLabel name, JLabel value, JPanel panel, GridBagConstraints c) {
        c.gridwidth = 1;
        c.weightx = 0.0;
        panel.add((Component)name, c);
        c.weightx = 0.75;
        c.insets = new Insets(0, 0, 0, 5);
        panel.add((Component)new JLabel(":"), c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        panel.add((Component)value, c);
    }

    private void copyToClipBoard(Collection<E2EBuilderModule> modules, XSLTToolsInfo xsltToolsInfo) {
        StringBuilder result = new StringBuilder(this.applicationInfo).append('\n');
        if (this.runtimeVersion != null) {
            result.append("Runtime ").append(this.runtimeVersion).append('\n');
        }
        for (E2EBuilderModule module : modules) {
            if (result.length() == 0) {
                result.append(module.getModuleInfo().toString());
                continue;
            }
            result.append('\n').append(module.getModuleInfo().toString());
        }
        if (xsltToolsInfo != null) {
            result.append('\n').append(xsltToolsInfo.toString());
        }
        StringSelection contents = new StringSelection(result.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, contents);
    }
}

