/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.application;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.application.Logging;
import ch.e2e.transaction.TransactionEvent;
import ch.e2e.transaction.TransactionException;
import ch.e2e.transaction.TransactionHandler;
import ch.e2e.transaction.TransactionListener;

public abstract class E2EBuilderTransaction
implements TransactionHandler,
TransactionListener {
    private boolean useThread;

    public E2EBuilderTransaction() {
        this.useThread = true;
    }

    public E2EBuilderTransaction(boolean useThread) {
        this.useThread = useThread;
    }

    public boolean useThread() {
        return this.useThread;
    }

    public final void transactionStart(TransactionEvent event) {
        this.prepareTransaction();
    }

    public final void transactionEnd(TransactionEvent event) {
        try {
            this.setTransactionResult(event.getResult());
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "transactionEnd(TransactionEvent)", e);
        }
    }

    public final void transactionFailed(TransactionException exception) {
        exception.setConsumed(this.doErrorHandling(exception.getTargetException()));
    }

    public abstract Object doTransaction(Object var1) throws Throwable;

    public abstract void prepareTransaction();

    public abstract void setTransactionResult(Object var1);

    public abstract String getDescription();

    public boolean doErrorHandling(Throwable error) {
        String classname = this.getClass().getName();
        E2EBuilder.logger.severe("Doing errorhandling of " + classname + ". Cause: " + error.getClass().getName());
        E2EBuilder.logger.throwing(classname, "doErrorHandling", error);
        return false;
    }
}

