/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.response;

import ch.e2e.builder.trace.testcase.response.Logging;
import ch.e2e.transformer.TransformerLoadException;
import ch.e2e.transformer.TransformerLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.MissingResourceException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ActionScriptTransformer {
    public static final String XML_line = "line";
    public static final String XSLT_SCRIPT_ACTIONSCRIPT = "ch/e2e/builder/trace/xslt/soap2asl/functions";
    private static final TransformerLoader transformerLoader;
    private static final ErrorListener errorListener;
    private static Transformer transformer;
    private static String xmlpath;

    public String transform(InputStream source) throws IOException, TransformerException, TransformerLoadException {
        return this.transform(new InputStreamReader(source));
    }

    public String transform(Reader source) throws TransformerException, TransformerLoadException, IOException {
        return this.transform(new StreamSource(source));
    }

    public String transform(Source source) throws TransformerException, TransformerLoadException, IOException {
        DOMResult documentResult = new DOMResult();
        this.getTransformer().transform(source, documentResult);
        StringBuilder result = new StringBuilder();
        NodeList lines = ((Document)documentResult.getNode()).getDocumentElement().getElementsByTagName(XML_line);
        int length = lines.getLength();
        for (int i = 0; i < length; ++i) {
            Element line = (Element)lines.item(i);
            if (line.getFirstChild() == null) continue;
            result.append(line.getFirstChild().getNodeValue()).append("\n");
        }
        return result.toString();
    }

    private Transformer getTransformer() throws TransformerLoadException {
        Transformer t = transformer;
        if (t == null) {
            t = transformerLoader.getTransformer(XSLT_SCRIPT_ACTIONSCRIPT);
            t.setErrorListener(errorListener);
            if (xmlpath == null) {
                transformer = t;
            }
        }
        return t;
    }

    static {
        try {
            xmlpath = System.getProperty("ch.e2e.builder.traceviewer.xmlpath");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        transformerLoader = new TransformerLoader(xmlpath, ActionScriptTransformer.class.getClassLoader());
        errorListener = new TransformerErrorListener();
    }

    private static class TransformerErrorListener
    implements ErrorListener {
        private TransformerErrorListener() {
        }

        @Override
        public void warning(TransformerException e) {
            Logging.logger.warning("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "warning", e);
        }

        @Override
        public void error(TransformerException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "error", e);
        }

        @Override
        public void fatalError(TransformerException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "fatalError", e);
        }
    }
}

