/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.AdapterOutputContainer;
import ch.e2e.builder.trace.testcase.AdapterTemplate;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterFactory;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import ch.e2e.dom.DomUtilities;
import ch.e2e.swing.TreeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdapterOutput
implements TreeObject {
    private AdapterOutputContainer container;
    private AdapterTemplate adapterTemplate;
    private List<Parameter> parameters = new ArrayList<Parameter>();

    public AdapterOutput(Element element, AdapterTemplate adapterTemplate) {
        this.adapterTemplate = adapterTemplate;
        try {
            NodeList parameterNodes = (NodeList)DomUtilities.evaluate((Node)element, (String)"*", (QName)XPathConstants.NODESET);
            ParameterFactory.createParameter(parameterNodes, this.parameters, new ArrayList<String>(), false, null, adapterTemplate);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public AdapterOutput(Element element, boolean namespaceAware, AdapterTemplate adapterTemplate) {
        this.adapterTemplate = adapterTemplate;
        try {
            NodeList parameterNodes = (NodeList)DomUtilities.evaluate((Node)element, (String)"*", (QName)XPathConstants.NODESET);
            ParameterFactory.createParameter(parameterNodes, this.parameters, new ArrayList<String>(), false, null, adapterTemplate, namespaceAware);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public AdapterOutput(AdapterTemplate adapterTemplate) {
        this.adapterTemplate = adapterTemplate;
        for (Parameter parameter : adapterTemplate.getParameters()) {
            this.parameters.add(parameter.createEmptyParameter((RecordParameter)null));
        }
    }

    public AdapterOutput(AdapterOutput adapterOutput) {
        this.adapterTemplate = adapterOutput.adapterTemplate;
        for (Parameter parameter : adapterOutput.parameters) {
            this.parameters.add(parameter.copy(null));
        }
    }

    public AdapterOutput copy() {
        return new AdapterOutput(this);
    }

    public AdapterTemplate getTemplate() {
        return this.adapterTemplate;
    }

    public AdapterOutputContainer getContainer() {
        return this.container;
    }

    public void setContainer(AdapterOutputContainer container) {
        this.container = container;
    }

    public boolean isChanged() {
        for (Parameter parameter : this.parameters) {
            if (!parameter.isChanged()) continue;
            return true;
        }
        return false;
    }

    public Element createAdapterOutputElement(Document document) {
        Element element = document.createElement(this.getAdapterType());
        element.setAttribute("name", this.getId());
        for (Parameter parameter : this.parameters) {
            element.appendChild(parameter.createParameterElement(document));
        }
        return element;
    }

    public Element createAdapterOutputSoapElement(Document document) {
        Element adapterElement = document.createElement(this.getAdapterType());
        adapterElement.setAttribute("name", this.getId());
        Element outputElement = document.createElement("output");
        adapterElement.appendChild(outputElement);
        ParameterFactory.appendSOAPChilds(this.parameters, outputElement, document);
        return adapterElement;
    }

    public String getId() {
        return this.adapterTemplate.getId();
    }

    public String getName() {
        return this.adapterTemplate.getName();
    }

    public String getAdapterType() {
        return this.adapterTemplate.getAdapterType();
    }

    public Collection<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        for (Parameter parameter : this.parameters) {
            if (!(parameter instanceof RecordParameter)) continue;
            namespaces.addAll(((RecordParameter)parameter).getNamespaces());
        }
        return Collections.unmodifiableCollection(namespaces);
    }

    public Object getChild(int index) {
        return this.parameters.get(index);
    }

    public int getChildCount() {
        return this.parameters.size();
    }

    public int getIndexOfChild(Object child) {
        return this.parameters.indexOf(child);
    }

    public boolean isLeaf() {
        return this.parameters.isEmpty();
    }

    public int getType() {
        return 10003;
    }

    public String toString() {
        return this.getAdapterType();
    }

    public boolean differsFrom(AdapterOutput other) {
        int childCount = this.getChildCount();
        boolean differs = childCount != other.getChildCount();
        for (int i = 0; !differs && i < childCount; ++i) {
            differs = this.parameters.get(i).differsFrom(other.parameters.get(i));
        }
        return differs;
    }
}

