/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.state;

import ch.e2e.builder.trace.gui.uml.UmlVertexView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.VertexRenderer;

public class SignalView
extends UmlVertexView {
    private static final SignalRenderer RENDERER = new SignalRenderer();

    public SignalView() {
    }

    public SignalView(Object cell) {
        super(cell);
    }

    @Override
    public CellViewRenderer getRenderer() {
        return RENDERER;
    }

    protected static class SignalRenderer
    extends VertexRenderer {
        private static final double SQRT_3 = Math.sqrt(3.0);

        protected SignalRenderer() {
        }

        public void paint(Graphics g) {
            this.paintWarningSymbol(g);
            this.setOpaque(false);
            super.paint(g);
        }

        private void paintWarningSymbol(Graphics g) {
            BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(stroke);
            int h = this.getHeight() - g.getFontMetrics(this.getFont()).getHeight();
            int s = (int)Math.round((double)(2 * h) / SQRT_3);
            int xOff = (this.getWidth() - s) / 2;
            int[] x = new int[]{xOff, xOff + s / 2, xOff + s, xOff};
            int[] y = new int[]{h, 0, h, h};
            int[] xBorder = new int[]{xOff, xOff + s / 2, xOff + s - 2, xOff};
            int[] yBorder = new int[]{h - 2, 0, h - 2, h - 2};
            int nPoints = x.length;
            g.setColor(this.getBackground());
            g2d.fillPolygon(x, y, nPoints);
            g.setColor(Color.BLACK);
            g2d.drawPolygon(xBorder, yBorder, 4);
            int l = Math.round(0.6f * (float)(h - 4));
            g2d.drawLine(xOff + s / 2, (h - l) / 2 + 2, xOff + s / 2, (h + l) / 2 + 2);
        }
    }
}

