/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.parameter;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.parameter.BooleanParameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeCellEditor;

public class BooleanEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private final JComboBox realEditor = new JComboBox<Boolean>(new Boolean[]{Boolean.TRUE, Boolean.FALSE});

    public BooleanEditor(E2EBuilderModule module) {
        this.realEditor.setBorder(null);
        this.realEditor.setRenderer(new BooleanListCellRenderer());
        this.realEditor.setBackground(Color.WHITE);
        this.realEditor.setOpaque(true);
        this.realEditor.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ch.e2e.builder.trace.booleanEditor.Enter");
        this.realEditor.getActionMap().put("ch.e2e.builder.trace.booleanEditor.Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BooleanEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.realEditor.getSelectedItem();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (value instanceof BooleanParameter) {
            BooleanParameter actualParameter = (BooleanParameter)value;
            this.realEditor.setSelectedItem(actualParameter.getValue() == null ? Boolean.FALSE : actualParameter.getValue());
        }
        return this.realEditor;
    }

    private class BooleanListCellRenderer
    extends DefaultListCellRenderer {
        public BooleanListCellRenderer() {
            this.setBorder(new LineBorder(Color.BLACK));
        }
    }
}

