/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.util.Map;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.QNameValue;

public class MessageCount
extends SystemFunction {
    public IntegerValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        Controller controller = context.getController();
        if (!(controller instanceof XsltController)) {
            return Int64Value.ZERO;
        }
        Map<StructuredQName, Integer> counters = ((XsltController)controller).getMessageCounters();
        QNameValue arg = (QNameValue)arguments[0].head();
        if (arg == null) {
            long total = 0L;
            for (int n : counters.values()) {
                total += (long)n;
            }
            return new Int64Value(total);
        }
        Integer c = counters.get(arg.getStructuredQName());
        int result = c == null ? 0 : c;
        return new Int64Value(result);
    }
}

