/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.event.EventController;
import ch.e2e.test.E2ETestResult;
import ch.e2e.test.E2ETestSource;
import ch.e2e.test.ErrorElement;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.TestEndEvent;
import ch.e2e.test.TestErrorEvent;
import ch.e2e.test.TestFailureEvent;
import ch.e2e.test.TestLogfile;
import ch.e2e.test.TestStartEvent;
import ch.e2e.test.TestType;
import ch.e2e.test.Testable;
import ch.e2e.test.Utilities;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.StringOption;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.custommonkey.xmlunit.XMLTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class E2ETest
extends XMLTestCase
implements OptionContainer,
TestListener {
    public static final String KEY_OPTION_TEST_NAME = "key.option.test.name";
    private TestType type;
    private HashMap<String, ArrayList<E2ETestSource>> sources = new HashMap();
    private ArrayList<ErrorElement> errors = new ArrayList();
    private Map<String, String> properties = new HashMap<String, String>();
    private TestLogfile logfile;
    private E2ETestResult result;
    private StringOption nameOption;
    private Testable owner;
    private HashMap<String, Option> advancedOptions;
    private HashMap<String, Option> options;
    private File referenceFolder;
    private File sourceFolder;
    private File testFolder;
    private Map<String, String> runProperties = new HashMap<String, String>();
    private TestResult testResult;

    protected E2ETest() {
        super("executeTest");
        StringOption name = new StringOption("Name", KEY_OPTION_TEST_NAME, -100);
        this.setName(name);
        this.createOptions();
    }

    public void setName(StringOption nameOption) {
        this.nameOption = nameOption;
        this.addOption(KEY_OPTION_TEST_NAME, nameOption);
    }

    @Override
    public StringOption getNameOption() {
        return this.nameOption;
    }

    public void rename(String name) {
        this.nameOption.setValue(name);
    }

    public String toString() {
        return this.nameOption == null || this.nameOption.getValue() == null ? "" : (((String)this.nameOption.getValue()).length() == 0 ? (String)this.nameOption.getDefaultValue() : (String)this.nameOption.getValue());
    }

    public void executeTest() throws Exception {
        this.doTest();
        if (this.result != null) {
            this.result.doTest(this);
        }
    }

    public Map<String, String> getRunProperties() {
        return this.runProperties;
    }

    @Override
    public void mergeOptions(Element options, Map<String, String> properties) {
        this.readSources(options.getElementsByTagName("source"), false);
        Utilities.readOptions(options.getElementsByTagName("option"), false, this);
    }

    @Override
    public Testable getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Testable owner) {
        this.owner = owner;
        this.setProperties(owner.getProperties());
    }

    public E2ETestSource getSource(String name) {
        E2ETestSource result = null;
        ArrayList<E2ETestSource> sourceList = this.sources.get(name);
        if (sourceList != null) {
            result = sourceList.get(sourceList.size() - 1);
        }
        return result;
    }

    public ArrayList<E2ETestSource> getSources(String name) {
        return this.sources.get(name);
    }

    public void addError(Throwable error) {
        this.addError(new ErrorElement(error));
    }

    public void addError(ErrorElement error) {
        error.setOwner(this);
        this.errors.add(error);
    }

    public ArrayList<ErrorElement> getErrors() {
        return this.errors;
    }

    public boolean isRecommendedCompareType(TestType type) {
        return type.getName().equalsIgnoreCase(this.getRecommendedCompareType());
    }

    public void setOption(String key, String value) {
        Option option = this.getOption(key);
        option.setValue(option.createValue(value));
    }

    @Override
    public final HashMap<String, Option> getAdvancedOptions() {
        if (this.advancedOptions == null) {
            this.advancedOptions = new HashMap();
        }
        return this.advancedOptions;
    }

    @Override
    public void setAdvancedOptions(HashMap<String, Option> advancedOptions) {
        this.advancedOptions = advancedOptions;
    }

    @Override
    public final HashMap<String, Option> getOptions() {
        if (this.options == null) {
            this.options = new HashMap();
        }
        return this.options;
    }

    @Override
    public void setOptions(HashMap<String, Option> options) {
        this.options = options;
    }

    public final void addOption(String key, Option option) {
        this.getOptions().put(key, option);
    }

    public final Option getOption(String key) {
        return this.getOptions().get(key);
    }

    public final Object getOptionValue(String key) {
        return Utilities.getOptionValue(key, this, this.runProperties);
    }

    public abstract void doTest() throws Exception;

    public abstract String getRecommendedCompareType();

    public final void removeData() {
        this.runProperties = Utilities.collectProperties(this.getOwner());
        this.runProperties.putAll(this.properties);
        this.removeSourceData();
        this.removeOutputData();
        this.removeReferenceData();
    }

    public final void removeReferenceAndSource() {
        this.runProperties = Utilities.collectProperties(this.getOwner());
        this.runProperties.putAll(this.properties);
        this.removeReferenceData();
        this.removeSourceData();
    }

    private void removeReferenceData() {
        this.result.removeReferenceData(this.runProperties);
    }

    public void removeSourceData() {
    }

    public final void removeOutput() {
        this.runProperties = Utilities.collectProperties(this.getOwner());
        this.runProperties.putAll(this.properties);
        this.removeOutputData();
    }

    public void removeOutputData() {
    }

    public void initialize(Element testcase) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.readSources(testcase);
        this.setResult(this.createTestResult(testcase));
        this.prepareCompareTypes();
    }

    protected void initializeSources() {
    }

    public void prepareCompareTypes() {
        if (this.result != null) {
            for (ResultCompare compare : this.result.getResultCompares()) {
                this.prepareCompareType(compare);
            }
        }
    }

    public void prepareCompareType(ResultCompare compare) {
    }

    public File getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(File sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public final void moveSourceData(File oldSourceFolder, File newSourceFolder) {
        this.runProperties = Utilities.collectProperties(this.getOwner());
        this.runProperties.putAll(this.properties);
        this.moveSources(oldSourceFolder, newSourceFolder);
    }

    protected void moveSources(File oldSourceFolder, File newSourceFolder) {
    }

    public File getReferenceFolder() {
        return this.referenceFolder;
    }

    public void setReferenceFolder(File referenceFolder) {
        this.referenceFolder = referenceFolder;
    }

    public void moveReferenceData(File oldReferenceFolder, File newReferenceFolder) {
        this.runProperties = Utilities.collectProperties(this.getOwner());
        this.runProperties.putAll(this.properties);
        this.result.moveReferenceData(oldReferenceFolder, newReferenceFolder, this.runProperties);
        this.referenceFolder = newReferenceFolder;
    }

    public final void changeOutputFolder(File oldOutputFolder, File newOutputFolder) {
        this.resetOutputFolder(oldOutputFolder, newOutputFolder);
    }

    protected void resetOutputFolder(File oldOutputFolder, File newOutputFolder) {
    }

    public File getTestFolder() {
        return this.testFolder;
    }

    public void setTestFolder(File testFolder) {
        this.testFolder = testFolder;
    }

    @Override
    public OptionContainer clone() throws CloneNotSupportedException {
        return (OptionContainer)super.clone();
    }

    protected void createOptions() {
    }

    protected final void setUp() {
        this.doSetup();
    }

    protected void doSetup() {
    }

    protected final void tearDown() {
        this.doTearDown();
    }

    protected void doTearDown() {
    }

    public void clear() {
        this.runProperties = Utilities.collectProperties(this.getOwner());
        this.runProperties.putAll(this.properties);
        for (ErrorElement error : this.errors) {
            error.clear();
        }
        this.errors.clear();
        if (this.result != null) {
            this.result.clear(this.runProperties);
        }
    }

    public void cleanOut() {
        for (ArrayList<E2ETestSource> sources : this.sources.values()) {
            for (E2ETestSource source : sources) {
                source.cleanOut();
            }
            sources.clear();
        }
        for (ErrorElement error : this.errors) {
            error.clear();
        }
        if (this.properties != null) {
            this.properties.clear();
        }
        if (this.options != null) {
            this.options.clear();
        }
        if (this.advancedOptions != null) {
            this.advancedOptions.clear();
        }
        if (this.runProperties != null) {
            this.runProperties.clear();
        }
    }

    public void run(TestResult testResult) {
        this.testResult = testResult;
        this.runProperties = Utilities.collectProperties(this.getOwner());
        this.runProperties.putAll(this.properties);
        this.errors.clear();
        if (this.result != null) {
            this.result.clear(this.runProperties);
        }
        testResult.addListener((TestListener)this);
        if (this.logfile != null) {
            testResult.addListener((TestListener)this.logfile);
        }
        super.run(testResult);
        if (this.logfile != null) {
            testResult.removeListener((TestListener)this.logfile);
        }
        testResult.removeListener((TestListener)this);
        this.testResult = null;
    }

    @Override
    public TestType getType() {
        return this.type;
    }

    @Override
    public void setType(TestType type) {
        this.type = type;
    }

    public void readSources(Element xmlElement) {
        NodeList options = xmlElement.getElementsByTagName("options");
        if (options == null || options.getLength() == 0) {
            options = xmlElement.getElementsByTagName("sources");
        }
        if (options != null && options.getLength() == 1) {
            NodeList sourceList = ((Element)options.item(0)).getElementsByTagName("source");
            if (sourceList != null && sourceList.getLength() > 0) {
                this.readSources(sourceList, false);
                this.initializeSources();
            }
            Utilities.readOptions(((Element)options.item(0)).getElementsByTagName("option"), false, this);
        }
    }

    public void readSources(NodeList sources, boolean inherited) {
        int length = sources.getLength();
        for (int i = 0; i < length; ++i) {
            Element source = (Element)sources.item(i);
            String name = source.getAttribute("name");
            ArrayList<E2ETestSource> sourceList = this.sources.get(name);
            if (sourceList == null) {
                sourceList = new ArrayList();
                this.sources.put(name, sourceList);
            }
            sourceList.add(new E2ETestSource(source));
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void deleteLogfile() {
        if (this.logfile != null) {
            this.logfile.delete();
        }
    }

    public TestLogfile getLogfile() {
        return this.logfile;
    }

    public void setLogfile(TestLogfile logfile) {
        this.logfile = logfile;
    }

    public void log(String message) {
        if (this.logfile != null) {
            this.logfile.printMessage(message);
        }
    }

    public void setResult(E2ETestResult result) {
        this.result = result;
    }

    public E2ETestResult getResult() {
        return this.result;
    }

    public TestResult getTestResult() {
        return this.testResult;
    }

    @Override
    public Element optionsToXml(boolean includeType, Document ownerDocument) {
        Element options = ownerDocument.createElement("options");
        if (includeType) {
            options.setAttribute("type", this.getType().getName());
        }
        for (Option option : this.getOptions().values()) {
            if (option.isInherited() || option.getValue() == null) continue;
            option.toXml(options);
        }
        return options;
    }

    public void addError(Test test, Throwable t) {
        EventController.fire((EventObject)new TestErrorEvent(this, test, t));
        this.addError(t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        EventController.fire((EventObject)new TestFailureEvent(this, test, t));
        this.addError(t);
    }

    public void endTest(Test test) {
        EventController.fire((EventObject)new TestEndEvent(this, test));
    }

    public void startTest(Test test) {
        EventController.fire((EventObject)new TestStartEvent(this, test));
    }

    protected E2ETestResult createTestResult(Element testcase) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        E2ETestResult result = null;
        NodeList compares = testcase.getElementsByTagName("results");
        if (compares == null || compares.getLength() == 0) {
            compares = testcase.getElementsByTagName("compare");
        }
        if (compares != null && compares.getLength() == 1) {
            result = new E2ETestResult((Element)compares.item(0), this.getOwner());
        }
        return result;
    }

    public void doCancel() {
    }

    public final void cancel() {
        this.doCancel();
        if (this.result != null) {
            this.result.doCancel();
        }
    }
}

