/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.ldap;

import ch.e2e.bridge.server.dataitem.ArrayItem;
import ch.e2e.bridge.server.dataitem.ItemFactory;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.ldap.AbstractAction;
import ch.e2e.bridge.server.ldap.parameter.LDAPDirEntry;
import ch.e2e.bridge.server.ldap.wrapper.LDAPAttributeWrapper;
import ch.e2e.bridge.server.ldap.wrapper.LDAPDirEntryWrapper;
import ch.e2e.bridge.server.session.Session;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;

public class GetAttributesAction
extends AbstractAction {
    public GetAttributesAction(InitialLdapContext context) {
        super(context);
    }

    @Override
    public boolean execute(RecordItem inputItem, RecordItem outputItem, Session session) throws Exception {
        boolean result = false;
        LDAPDirEntry dirEntry = (LDAPDirEntry)session.createObject(inputItem.getRecordItem(0), LDAPDirEntryWrapper.class);
        if (dirEntry != null) {
            try {
                Attributes attributes = this.context.getAttributes(dirEntry.getDn());
                ArrayItem attributesItem = ItemFactory.createArrayItem(session);
                attributesItem.setValues(attributes.getAll(), LDAPAttributeWrapper.class);
                outputItem.addItem(attributesItem);
                result = true;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return result;
    }
}

