/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.JavaVirtualMachine;
import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.PoolConfig;
import ch.e2e.bridge.server.jms.impl.ConnectionAdapter;
import ch.e2e.bridge.server.jms.impl.ConnectionAdapterPool;
import ch.e2e.bridge.server.jms.impl.JMSMessageListener;
import ch.e2e.bridge.server.jms.parameter.JMSReceiveParameter;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import net.jcip.annotations.GuardedBy;

public class JMSMessageListenerPool {
    private final PoolConfig poolConfig;
    private final int messageType;
    private final JMSReceiveParameter receiveParameter;
    private final JMSSessionParameter sessionParameter;
    @GuardedBy(value="this")
    private final HashMap<Long, JMSMessageListener> messageListeners;
    @GuardedBy(value="this")
    private final HashMap<Long, JMSMessageListener> activeListeners;
    private Timer evictionTimer;

    JMSMessageListenerPool(PoolConfig poolConfig, int messageType, JMSReceiveParameter receiveParameter, JMSSessionParameter sessionParameter) throws Exception {
        this.poolConfig = poolConfig;
        this.messageType = messageType;
        this.receiveParameter = receiveParameter;
        this.sessionParameter = sessionParameter;
        this.messageListeners = new HashMap();
        this.activeListeners = new HashMap();
        this.ensureMinIdle();
        this.startEnvictor();
    }

    synchronized void borrowObject(JMSMessageListener listener) {
        if (!JavaVirtualMachine.shutdown) {
            this.messageListeners.remove(listener.getId());
            this.activeListeners.put(listener.getId(), listener);
            try {
                this.ensureMinIdle();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    synchronized void returnObject(JMSMessageListener listener) {
        if (!JavaVirtualMachine.shutdown) {
            this.activeListeners.remove(listener.getId());
            this.messageListeners.put(listener.getId(), listener);
        }
    }

    public void shutdown() {
        JMSLogger.getInstance().debug("2", "JMSMessageListenerPool received shutdownInternal signal.");
        if (this.evictionTimer != null) {
            this.evictionTimer.cancel();
        }
        for (JMSMessageListener messageListener : this.messageListeners.values()) {
            try {
                messageListener.close();
            }
            catch (Exception exception) {}
        }
        this.messageListeners.clear();
        for (JMSMessageListener messageListener : this.activeListeners.values()) {
            try {
                messageListener.close();
            }
            catch (Exception exception) {}
        }
        this.activeListeners.clear();
    }

    private synchronized void ensureMinIdle() throws Exception {
        int start;
        for (int i = start = this.messageListeners.size(); i < this.poolConfig.getMinIdle() && this.messageListeners.size() + this.activeListeners.size() < this.poolConfig.getMaxTotal(); ++i) {
            ConnectionAdapter connection = ConnectionAdapterPool.getInstance().borrowObject(this.sessionParameter);
            JMSMessageListener messageListener = new JMSMessageListener(this.receiveParameter.getDestinationName(), this.receiveParameter.getSelector(), this.receiveParameter.getCallback(), this.messageType, i, this);
            connection.registerListener(messageListener);
            ConnectionAdapterPool.getInstance().returnObject(this.sessionParameter, connection);
            this.messageListeners.put(messageListener.getId(), messageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evict() throws Exception {
        ArrayList<JMSMessageListener> shouldBeClosed = new ArrayList<JMSMessageListener>();
        JMSMessageListenerPool jMSMessageListenerPool = this;
        synchronized (jMSMessageListenerPool) {
            Iterator<JMSMessageListener> listeners = this.messageListeners.values().iterator();
            long time = System.currentTimeMillis();
            while (listeners.hasNext() && this.messageListeners.size() > this.poolConfig.getMinIdle()) {
                JMSMessageListener listener = listeners.next();
                if (time - listener.getTstamp() <= (long)this.poolConfig.getMinEvictableIdleTimeMillis()) continue;
                shouldBeClosed.add(listener);
                this.messageListeners.remove(listener.getId());
            }
        }
        for (JMSMessageListener listener : shouldBeClosed) {
            listener.close();
        }
    }

    private void startEnvictor() {
        if (this.poolConfig.getTimeBetweenEvictionRunsMillis() > 0) {
            this.evictionTimer = new Timer();
            this.evictionTimer.schedule((TimerTask)new Evictor(), this.poolConfig.getTimeBetweenEvictionRunsMillis(), (long)this.poolConfig.getTimeBetweenEvictionRunsMillis());
        }
    }

    private class Evictor
    extends TimerTask {
        private Evictor() {
        }

        @Override
        public void run() {
            try {
                JMSMessageListenerPool.this.evict();
            }
            catch (Exception exception) {
            }
            catch (OutOfMemoryError e) {
                JMSLogger.getInstance().error("JMS15", "out of memory (trying to recover)", e);
            }
            try {
                JMSMessageListenerPool.this.ensureMinIdle();
            }
            catch (Exception exception) {
                // empty catch block
            }
            JMSLogger.getInstance().debug("EVICTION called", "idle listeners: " + JMSMessageListenerPool.this.messageListeners.size() + ", activeListeners: " + JMSMessageListenerPool.this.activeListeners.size());
        }
    }
}

