/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.dataitem;

import ch.e2e.bridge.server.BridgeException;
import ch.e2e.bridge.server.dataitem.SimpleItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class DateTimeItem
extends SimpleItem {
    private static String timeZoneID;

    private static native long nativeCreate();

    private static native long nativeConvertToStringItem(long var0);

    private static native void nativeSetValue(long var0, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    private static native void nativeSetYear(long var0, int var2);

    private static native void nativeSetMonth(long var0, int var2);

    private static native void nativeSetDay(long var0, int var2);

    private static native void nativeSetHours(long var0, int var2);

    private static native void nativeSetMinutes(long var0, int var2);

    private static native void nativeSetSeconds(long var0, int var2);

    private static native void nativeSetMicroSeconds(long var0, long var2);

    private static native int nativeGetWeekDay(long var0);

    private static native int nativeGetYear(long var0);

    private static native int nativeGetMonth(long var0);

    private static native int nativeGetDay(long var0);

    private static native int nativeGetHours(long var0);

    private static native int nativeGetMinutes(long var0);

    private static native int nativeGetSeconds(long var0);

    private static native long nativeGetMicroSeconds(long var0);

    private static native byte nativeCompare(long var0, long var2);

    private static native void nativeAdd(long var0, long var2);

    private static native void nativeSubtract(long var0, long var2);

    DateTimeItem() {
        super(DateTimeItem.nativeCreate());
    }

    DateTimeItem(long nativeItem) {
        super(nativeItem);
    }

    public StringItem convertToStringItem() {
        return new StringItem(DateTimeItem.nativeConvertToStringItem(this.getNativeItem()));
    }

    public void setValue(int year, int month, int day, int hours, int minutes, int seconds, long microSeconds) {
        DateTimeItem.nativeSetValue(this.getNativeItem(), year, month, day, hours, minutes, seconds, microSeconds);
    }

    public void setYear(int year) {
        DateTimeItem.nativeSetYear(this.getNativeItem(), year);
    }

    public void setMonth(int month) {
        DateTimeItem.nativeSetMonth(this.getNativeItem(), month);
    }

    public void setDay(int day) {
        DateTimeItem.nativeSetDay(this.getNativeItem(), day);
    }

    public void setHours(int hours) {
        DateTimeItem.nativeSetHours(this.getNativeItem(), hours);
    }

    public void setMinutes(int minutes) {
        DateTimeItem.nativeSetMinutes(this.getNativeItem(), minutes);
    }

    public void setSeconds(int seconds) {
        DateTimeItem.nativeSetSeconds(this.getNativeItem(), seconds);
    }

    public void setMicroSeconds(long microSeconds) {
        DateTimeItem.nativeSetMicroSeconds(this.getNativeItem(), microSeconds);
    }

    public int getWeekDay() {
        return DateTimeItem.nativeGetWeekDay(this.getNativeItem());
    }

    public int getYear() {
        return DateTimeItem.nativeGetYear(this.getNativeItem());
    }

    public int getMonth() {
        return DateTimeItem.nativeGetMonth(this.getNativeItem());
    }

    public int getDay() {
        return DateTimeItem.nativeGetDay(this.getNativeItem());
    }

    public int getHours() {
        return DateTimeItem.nativeGetHours(this.getNativeItem());
    }

    public int getMinutes() {
        return DateTimeItem.nativeGetMinutes(this.getNativeItem());
    }

    public int getSeconds() {
        return DateTimeItem.nativeGetSeconds(this.getNativeItem());
    }

    public long getMicroSeconds() {
        return DateTimeItem.nativeGetMicroSeconds(this.getNativeItem());
    }

    public byte compare(DateTimeItem value) {
        return DateTimeItem.nativeCompare(this.getNativeItem(), value.getNativeItem());
    }

    public void add(DateTimeItem value) {
        DateTimeItem.nativeAdd(this.getNativeItem(), value.getNativeItem());
    }

    public void subtract(DateTimeItem value) {
        DateTimeItem.nativeSubtract(this.getNativeItem(), value.getNativeItem());
    }

    @Override
    public Object getValueAsDateTime(Class dateTimeClass) {
        Object result;
        block5: {
            try {
                Constructor constructor = dateTimeClass.getConstructor(new Class[0]);
                result = constructor.newInstance(new Object[0]);
                int year = DateTimeItem.nativeGetYear(this.getNativeItem());
                int month = DateTimeItem.nativeGetMonth(this.getNativeItem());
                int day = DateTimeItem.nativeGetDay(this.getNativeItem()) + 1;
                int hours = DateTimeItem.nativeGetHours(this.getNativeItem());
                int minutes = DateTimeItem.nativeGetMinutes(this.getNativeItem());
                int seconds = DateTimeItem.nativeGetSeconds(this.getNativeItem());
                if (result instanceof Calendar) {
                    ((Calendar)result).setTimeZone(TimeZone.getTimeZone(timeZoneID));
                    ((Calendar)result).set(year, month, day, hours, minutes, seconds);
                    int millis = (int)DateTimeItem.nativeGetMicroSeconds(this.getNativeItem()) / 1000;
                    ((Calendar)result).set(14, millis);
                    break block5;
                }
                if (result instanceof Date) {
                    Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(timeZoneID));
                    calendar.set(year, month, day, hours, minutes, seconds);
                    int millis = (int)DateTimeItem.nativeGetMicroSeconds(this.getNativeItem()) / 1000;
                    calendar.set(14, millis);
                    ((Date)result).setTime(calendar.getTimeInMillis());
                    break block5;
                }
                throw new UnsupportedOperationException("Only Calendar and Date classes are supported as DateTime objects.");
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("Only Calendar and Date classes with default constructor are supported.");
            }
            catch (Exception e) {
                throw new BridgeException("Exception when initializing " + dateTimeClass.getName(), e);
            }
        }
        return result;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            this.setValue(calendar);
        } else if (value instanceof Calendar) {
            this.setValue((Calendar)((Calendar)value).clone());
        } else {
            super.setValue(value);
        }
    }

    private void setValue(Calendar calendar) {
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneID));
        DateTimeItem.nativeSetValue(this.getNativeItem(), calendar.get(1), calendar.get(2), calendar.get(5) - 1, calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000);
    }

    static {
        List<String> timeZones = Arrays.asList(TimeZone.getAvailableIDs());
        int index = timeZones.indexOf("UTC");
        timeZoneID = index == -1 ? Calendar.getInstance().getTimeZone().getID() : "UTC";
    }
}

