/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute;

import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.event.EventController;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.EventObject;

abstract class Header {
    static String CRLF = "\r\n";
    private static final int CHAR_LF = 10;
    private static final int CHAR_CR = 13;
    private long contentLength;
    private String requestId;
    private byte[] headerData;

    Header(InputStream in) throws MalformedURLException {
        ArrayList array = this.readLines(in);
        String firstLine = this.getFirstLine((String)array.get(0));
        array.remove(0);
        this.createHeader(firstLine, array);
    }

    public byte[] getHeaderData() {
        return this.headerData;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getRequestId() {
        return this.requestId;
    }

    String getFirstLine(String line) throws MalformedURLException {
        return line;
    }

    private void createHeader(String firstLine, ArrayList properties) {
        StringBuffer header = new StringBuffer(firstLine);
        int length = properties.size();
        for (int i = 0; i < length; ++i) {
            header.append((String)properties.get(i));
        }
        header.append(CRLF);
        this.headerData = header.toString().getBytes();
    }

    private ArrayList readLines(InputStream in) {
        ArrayList<String> array = new ArrayList<String>();
        try {
            int c;
            boolean endOfLine = false;
            StringBuffer buf = new StringBuffer();
            while (!((c = in.read()) == -1 || c == 10 && endOfLine)) {
                if (c == 13 && endOfLine) continue;
                if (c == 10) {
                    int index;
                    buf.append((char)c);
                    String line = buf.toString();
                    if (line.startsWith("Content-Length")) {
                        index = line.indexOf(58);
                        this.contentLength = Long.parseLong(line.substring(index + 1).trim());
                    } else if (line.startsWith("Request-ID")) {
                        index = line.indexOf(58);
                        this.requestId = line.substring(index + 1).trim();
                    }
                    array.add(line);
                    buf = new StringBuffer();
                    endOfLine = true;
                    continue;
                }
                buf.append((char)c);
                endOfLine = false;
            }
        }
        catch (IOException e) {
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.toString()));
        }
        return array;
    }
}

