/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types;

import ch.e2e.ant.gui.AntConsole;
import ch.e2e.ant.gui.configuration.types.Antcall;
import ch.e2e.ant.gui.configuration.types.Test;
import ch.e2e.dom.DomUtilities;
import ch.e2e.resource.Properties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestUnit
extends Antcall {
    private ArrayList<Test> tests = new ArrayList();

    public void addTest(Test test) {
        this.tests.add(test);
    }

    @Override
    public void execute(AntConsole antConsole, Properties properties) throws IOException, TransformerException {
        System.getProperties().putAll((Map<?, ?>)properties);
        File antfile = this.createAntfile(properties);
        super.setAntfile(antfile.getAbsolutePath());
        super.setBasedir(antfile.getParentFile());
        super.execute(antConsole, properties);
        for (Object key : properties.keySet()) {
            System.getProperties().remove(key);
        }
    }

    private File createAntfile(Properties properties) throws IOException, TransformerException {
        File buildFile = File.createTempFile("build", ".xml");
        Document document = DomUtilities.newDocument((String)"project");
        Element root = document.getDocumentElement();
        root.setAttribute("name", "e2etest");
        root.setAttribute("default", "do.test");
        Element target = document.createElement("target");
        target.setAttribute("name", "do.test");
        Element testunit = document.createElement("testunit");
        for (Test test : this.tests) {
            File testfile = test.createTestcaseFile(properties);
            Element testsuite = document.createElement("testsuite");
            testsuite.setAttribute("testcases", testfile.getAbsolutePath());
            testsuite.setAttribute("name", test.getName());
            testunit.appendChild(testsuite);
        }
        target.appendChild(testunit);
        root.appendChild(target);
        DomUtilities.serialize((File)buildFile, (Document)document, (boolean)true);
        return buildFile;
    }
}

