/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import ch.e2e.ant.gui.configuration.ConfigurationTools;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class TextFileTask
extends Task {
    private File file;
    private char commentChar = (char)35;
    private int linewidth = 0;
    private boolean append = false;
    private ArrayList lines = new ArrayList();
    private String os;
    private String ifString;
    private String unless;

    public void execute() throws BuildException {
        if (ConfigurationTools.checkIfUnless(this.ifString, this.unless, this.getProject()) && ConfigurationTools.checkOs(this.os)) {
            if (this.file == null) {
                throw new BuildException("The attribute 'file' must be set.");
            }
            this.writeFile();
        }
    }

    public void setIf(String ifString) {
        this.ifString = ifString;
    }

    public void setUnless(String unless) {
        this.unless = unless;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setCommentChar(char commentChar) {
        this.commentChar = commentChar;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setLinewidth(int linewidth) {
        this.linewidth = linewidth;
    }

    public Object createLine() {
        Line line = new Line();
        this.lines.add(line);
        return line;
    }

    public Object createComment() {
        Comment comment = new Comment();
        this.lines.add(comment);
        return comment;
    }

    public Object createMultilinecomment() {
        MultiLineComment comment = new MultiLineComment();
        this.lines.add(comment);
        return comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile() {
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(this.file.getAbsolutePath(), this.append));
            int length = this.lines.size();
            for (int i = 0; i < length; ++i) {
                out.print(this.lines.get(i).toString() + '\n');
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Could not write '" + this.file.getAbsolutePath() + "'");
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public class MultiLineComment {
        private String text;

        public void addText(String text) {
            this.text = TextFileTask.this.getProject().replaceProperties(text);
        }

        public String toString() {
            this.text = StringTools.removeAll((String)this.text, (char)'\n');
            this.text = StringTools.replaceAll((String)this.text, (String)"\\n", (String)"\n", (boolean)false);
            List lines = StringTools.createLines((String)this.text, (String)"\n", (boolean)true);
            int maxLinewidth = TextFileTask.this.linewidth;
            int length = lines.size();
            for (int i = 0; i < length; ++i) {
                maxLinewidth = Math.max(maxLinewidth, ((String)lines.get(i)).length() + 4);
            }
            StringBuffer str = new StringBuffer((length + 2) * maxLinewidth);
            str.append(StringTools.append((String)"", (int)maxLinewidth, (char)TextFileTask.this.commentChar) + '\n');
            for (int i = 0; i < length; ++i) {
                String line = StringTools.appendSpaces((String)((String)lines.get(i)), (int)(maxLinewidth - 3));
                str.append(new String(new char[]{TextFileTask.this.commentChar}) + ' ' + line + TextFileTask.this.commentChar + '\n');
            }
            str.append(StringTools.append((String)"", (int)maxLinewidth, (char)TextFileTask.this.commentChar));
            return str.toString();
        }
    }

    public class Comment
    extends Line {
        @Override
        public String toString() {
            this.text = this.text == null ? new String(new char[]{TextFileTask.this.commentChar}) : new String(new char[]{TextFileTask.this.commentChar}) + this.text;
            return super.toString();
        }
    }

    public class Line {
        protected String text;
        private Comment comment;

        public void addText(String text) {
            this.text = TextFileTask.this.getProject().replaceProperties(text);
        }

        public void setComment(String text) {
            this.comment = new Comment();
            this.comment.text = TextFileTask.this.getProject().replaceProperties(text);
        }

        public String toString() {
            if (this.text == null) {
                this.text = "";
            }
            return this.comment == null ? this.text : this.text + "  " + this.comment.toString();
        }
    }
}

