/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class LoggingReader
extends FilterReader {
    private static final int defaultCharBufferSize = 8192;
    private final Writer log;
    private boolean eof = false;

    public LoggingReader(Reader in, Writer log) {
        super(in);
        this.log = log;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n = super.read(cbuf, off, len);
        this.eof = n != -1;
        if (this.eof) {
            this.log.write(cbuf, off, n);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        if (!this.eof) {
            char[] buf = new char[8192];
            try {
                int n;
                while ((n = this.in.read(buf)) != -1) {
                    this.log.write(buf, 0, n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close();
        this.log.close();
    }
}

