<?xml version="1.0" encoding="UTF-8"?>

<!--
  ~ Copyright: Scheer E2E AG
  -->
<xsl:transform version="2.0"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               xmlns:xs="http://www.w3.org/2001/XMLSchema"
               xmlns:e2e="http://e2ebridge.com"
               exclude-result-prefixes="#all">

    <!-- 	========================================================================================
        Format output
        ======================================================================================== -->
    <xsl:output method="xml" indent="yes"/>

    <!-- 	========================================================================================
        Root
        ======================================================================================== -->
    <xsl:template match="OverrideSets">
        <Substitutions>

            <Files>
                <xsl:apply-templates select="OverrideSet" mode="substitutions.getFiles"/>
            </Files>

            <xsl:variable name="entries" as="item()*">
                <xsl:apply-templates select="." mode="override.preprocess.entries"/>
            </xsl:variable>

            <Dependencies>
                <xsl:apply-templates select="$entries" mode="substitutions.getDependencies"/>
            </Dependencies>

            <Variables>
                <xsl:apply-templates select="$entries" mode="substitutions.getVariableDefinitions"/>
            </Variables>

            <Display>
                <xsl:call-template name="substitutions.createDisplayCategories">
                    <xsl:with-param name="entries" select="$entries"/>
                </xsl:call-template>
            </Display>
        </Substitutions>
    </xsl:template>

    <!-- 	========================================================================================
        Extract file definitions
        ======================================================================================== -->
    <xsl:template match="OverrideSet" mode="substitutions.getFiles">
        <File>
            <xsl:attribute name="template" select="@source"/>
            <xsl:attribute name="target" select="@target"/>
        </File>
    </xsl:template>

    <!-- 	========================================================================================
        Extract dependencies between files and variables
        ======================================================================================== -->
    <xsl:template match="Entry" mode="substitutions.getDependencies">
        <Depending>
            <xsl:attribute name="on" select="@id"/>
            <xsl:if test="@oldId ne @id">
                <xsl:attribute name="as" select="@oldId"/>
            </xsl:if>
            <Dependent>
                <xsl:attribute name="template" select="@source"/>
            </Dependent>
        </Depending>
    </xsl:template>

    <!-- 	========================================================================================
        Extract variable definitions.
        ======================================================================================== -->
    <xsl:template match="Entry" mode="substitutions.getVariableDefinitions">
        <Variable>
            <xsl:attribute name="name" select="@id"/>
            <xsl:if test="@default">
                <xsl:attribute name="default" select="@default"/>
            </xsl:if>
            <xsl:if test="@type">
                <xsl:attribute name="type" select="@type"/>
            </xsl:if>
        </Variable>
    </xsl:template>


    <!-- 	========================================================================================
        Extract visual representation
        ======================================================================================== -->
    <xsl:template name="substitutions.createDisplayCategories">
        <xsl:param name="entries" as="item()*"/>
        <xsl:for-each-group select="$entries" group-by="@category">
            <Category>
                <xsl:attribute name="label"
                               select="if( current-grouping-key() eq 'addOn') then 'Add-Ons' else 'Global Settings'"/>
                <xsl:call-template name="substitutions.createDisplaySections">
                    <xsl:with-param name="entries" select="current-group()"/>
                </xsl:call-template>
            </Category>
        </xsl:for-each-group>
    </xsl:template>

    <xsl:template name="substitutions.createDisplaySections">
        <xsl:param name="entries" as="item()*"/>
        <xsl:for-each-group select="$entries" group-by="@sectionLabel">
            <Section>
                <xsl:attribute name="label" select="current-grouping-key()"/>
                    <xsl:apply-templates select="current-group()" mode="substitutions.getDisplay"/>
            </Section>
        </xsl:for-each-group>
    </xsl:template>

    <xsl:template match="Entry" mode="substitutions.getDisplay">
        <Override>
            <xsl:attribute name="label" select="@label"/>
            <xsl:attribute name="variable" select="@id"/>
        </Override>
    </xsl:template>


    <!-- 	========================================================================================
        Find all duplicated variable IDs.
        ======================================================================================== -->
    <xsl:template match="OverrideSets" mode="override.preprocess.entries">
        <xsl:for-each-group select="OverrideSet/Override" group-by="@id">
            <xsl:variable name="idGroupSize" select="count(current-group())"/>
            <xsl:for-each-group select="current-group()" group-by="../@label">
                <xsl:variable name="labelGroupSize" select="count(current-group())"/>
                <xsl:apply-templates select="current-group()[1]" mode="override.preprocess.entries.generate">
                    <xsl:with-param name="isDuplicate" select="($idGroupSize - $labelGroupSize) > 0"/>
                </xsl:apply-templates>
            </xsl:for-each-group>
        </xsl:for-each-group>
    </xsl:template>

    <xsl:template match="Override" mode="override.preprocess.entries.generate">
        <xsl:param name="isDuplicate" as="xs:boolean"/>
        <xsl:variable name="sectionLabel" select="../@label"/>
        <Entry>
            <xsl:attribute name="oldId" select="@id"/>
            <xsl:attribute name="id" select="if($isDuplicate) then concat(@id, '_', $sectionLabel) else @id"/>
            <xsl:attribute name="sectionLabel" select="$sectionLabel"/>
            <xsl:attribute name="default" select="@default"/>
            <xsl:attribute name="type" select="@type"/>
            <xsl:attribute name="label" select="@label"/>
            <xsl:attribute name="source" select="../@source"/>
            <xsl:attribute name="target" select="../@target"/>
            <xsl:attribute name="category" select="../@category"/>
        </Entry>
    </xsl:template>

</xsl:transform>
