/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.testcase;

import ch.e2e.builder.trace.testcase.TestcaseTemplate;
import ch.e2e.builder.traceviewer.testcase.Logging;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AsynchronousTestcaseTemplate
extends TestcaseTemplate {
    private boolean persistentState;
    private String namespace;
    private String asyncClass;
    private String asyncClassStereotype;
    private String type;
    private List<String> primaryKeyNames;

    public AsynchronousTestcaseTemplate(File templateFile) {
        super(templateFile);
    }

    public AsynchronousTestcaseTemplate(Element testcaseTemplate) {
        super(testcaseTemplate);
    }

    public String getName() {
        return (this.isPersistentState() ? this.asyncClass : this.getOperation()) + " [" + this.getLocation() + "]";
    }

    public int getTestcaseFolderType() {
        return this.isPersistentState() ? 21 : 27;
    }

    public String getAsynchronousClass() {
        return this.asyncClass;
    }

    public String getClassStereotype() {
        return this.asyncClassStereotype;
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<String> getPrimaryKeyNames() {
        return this.primaryKeyNames;
    }

    public boolean isPersistentState() {
        return this.persistentState;
    }

    protected void initialize(Element testcaseTemplate) {
        this.persistentState = testcaseTemplate.hasAttribute("persistentState");
        this.location = this.getAttribute(testcaseTemplate, "location");
        this.primaryKeyNames = new ArrayList<String>();
        XPath xPath = DomUtilities.newXPath();
        try {
            if (this.persistentState) {
                Element classElement = (Element)xPath.evaluate("PersistentStateClass", testcaseTemplate, XPathConstants.NODE);
                this.asyncClass = this.getAttribute(classElement, "name");
                if (this.asyncClass == null) {
                    this.asyncClass = "unkown";
                }
                this.namespace = this.getAttribute(classElement, "namespace");
                this.type = this.getAttribute(classElement, "type");
                this.fullQualifiedName = this.asyncClass;
                NodeList nodes = (NodeList)xPath.evaluate("PrimaryKeys/Key", classElement, XPathConstants.NODESET);
                int length = nodes.getLength();
                for (int i = 0; i < length; ++i) {
                    this.primaryKeyNames.add(((Element)nodes.item(i)).getAttribute("name"));
                }
            } else {
                Element element = (Element)xPath.evaluate("Service", testcaseTemplate, XPathConstants.NODE);
                if (element != null) {
                    this.service = this.getAttribute(element, "name");
                    if (this.service == null) {
                        this.service = "unkown";
                    }
                    Element classElement = (Element)xPath.evaluate("Class", element, XPathConstants.NODE);
                    this.asyncClass = this.getAttribute(classElement, "name");
                    if (this.asyncClass == null) {
                        this.asyncClass = "unkown";
                    }
                    this.asyncClassStereotype = this.getAttribute(classElement, "stereotype");
                    element = (Element)xPath.evaluate("Operation", classElement, XPathConstants.NODE);
                    this.operation = this.getAttribute(element, "name");
                    if (this.operation == null) {
                        this.operation = "unkown";
                    }
                    this.namespace = this.getAttribute(element, "namespace");
                    this.type = this.getAttribute(element, "type");
                    this.fullQualifiedName = this.service + '.' + this.asyncClass + '.' + this.operation;
                }
            }
        }
        catch (XPathExpressionException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(((Object)((Object)this)).getClass().getName(), "initialize", e);
        }
    }
}

