/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute;

import ch.e2e.dom.DomUtilities;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResponseContentHandler
extends DefaultHandler {
    private static final String XML_genericFlow = "genericFlow";
    private static final String XML_id = "id";
    private static final String XML_Trace = "Trace";
    private Document actualDocument;
    private Document responseDocument;
    private Document traceDocument;
    private Node actualNode;
    private Node lastResponseNode;
    private HashMap<String, String> prefixes = new HashMap();
    private int uniqueId;

    public Document getResponseDocument() {
        return this.responseDocument;
    }

    public Document getTraceDocument() {
        return this.traceDocument;
    }

    @Override
    public void startDocument() throws SAXException {
        this.actualDocument = this.responseDocument = DomUtilities.newDocument();
        this.actualNode = this.responseDocument;
        this.traceDocument = DomUtilities.newDocument((String)"TraceResponse");
        this.uniqueId = 0;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixes.put(uri, prefix);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals(XML_Trace)) {
            this.lastResponseNode = this.actualNode;
            this.actualDocument = this.traceDocument;
            this.actualNode = this.traceDocument.getDocumentElement();
            this.actualNode = this.appendElement(namespaceURI, qName, attributes, this.actualNode, this.actualDocument);
        } else {
            this.actualNode = this.appendElement(namespaceURI, qName, attributes, this.actualNode, this.actualDocument);
        }
    }

    private Element appendElement(String namespaceURI, String qName, Attributes attributes, Node actualNode, Document document) {
        Element element = document.createElementNS(namespaceURI, qName);
        element.setPrefix(this.prefixes.get(namespaceURI));
        actualNode.appendChild(element);
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            element.setAttributeNS(attributes.getURI(i), attributes.getQName(i), attributes.getValue(i));
        }
        if (qName.equals(XML_genericFlow)) {
            element.setAttribute(XML_id, String.valueOf(this.uniqueId++));
        }
        return element;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equals(XML_Trace)) {
            this.actualNode = this.lastResponseNode;
            this.actualDocument = this.responseDocument;
        } else {
            this.actualNode = this.actualNode.getParentNode();
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        String content = new String(chars, start, length);
        this.actualNode.appendChild(this.actualDocument.createTextNode(content));
    }
}

