/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import ch.e2e.builder.trace.testcase.uml.ScriptInput;
import ch.e2e.builder.trace.testcase.uml.ScriptOutput;
import java.io.File;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScriptObject
extends IOUmlObject {
    private Element xmlElement;
    private String xmlElementName;

    public ScriptObject(Element element, File documentFolder) {
        super(element, documentFolder);
        this.xmlElementName = element.getNodeName();
        this.checkErrors(element);
    }

    public ScriptObject(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        this.xmlElement = element;
        this.xmlElementName = element.getNodeName();
        this.checkErrors(element);
    }

    @Override
    public int internalGetType() {
        return 10000;
    }

    public String getXmlElementName() {
        return this.xmlElementName;
    }

    public Element getXmlElement() {
        return this.xmlElement;
    }

    public void clearXmlElement() {
        this.xmlElement = null;
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        if (child.getNodeName().equals("input")) {
            this.setInput(new ScriptInput(this, child, traceContainer));
        } else if (child.getNodeName().equals("output")) {
            this.setOutput(new ScriptOutput(this, child, traceContainer));
        } else {
            this.ioObjectAddChild(child, traceContainer);
        }
    }

    private void checkErrors(Element element) {
        NodeList messages = element.getElementsByTagName("message");
        if (messages != null) {
            int length = messages.getLength();
            for (int i = 0; i < length && !this.error; ++i) {
                Node node = messages.item(i);
                this.error = this.containsChild(node, "domain") && this.containsChild(node, "code") && this.containsChild(node, "category");
            }
        }
    }

    private boolean containsChild(Node node, String name) {
        boolean result = false;
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length && !result; ++i) {
            result = children.item(i).getNodeName().equals(name);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.xmlElementName + " expression";
    }
}

