/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.language;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.language.LanguageSpec;
import com.jidesoft.editor.tokenmarker.CCTokenMarker;
import com.jidesoft.editor.tokenmarker.CTokenMarker;
import com.jidesoft.editor.tokenmarker.HTMLTokenMarker;
import com.jidesoft.editor.tokenmarker.JavaScriptTokenMarker;
import com.jidesoft.editor.tokenmarker.JavaTokenMarker;
import com.jidesoft.editor.tokenmarker.PHPTokenMarker;
import com.jidesoft.editor.tokenmarker.PLSQLTokenMarker;
import com.jidesoft.editor.tokenmarker.PerlTokenMarker;
import com.jidesoft.editor.tokenmarker.PythonTokenMarker;
import com.jidesoft.editor.tokenmarker.TSQLTokenMarker;
import com.jidesoft.editor.tokenmarker.VHDLTokenMarker;
import com.jidesoft.editor.tokenmarker.VerilogTokenMarker;
import com.jidesoft.editor.tokenmarker.XMLTokenMarker;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LanguageSpecManager {
    private Map<String, LanguageSpec> a;
    private static LanguageSpecManager b;

    public static LanguageSpecManager getInstance() {
        LanguageSpecManager languageSpecManager = b;
        if (LanguageSpec.i == 0) {
            if (languageSpecManager == null) {
                b = new LanguageSpecManager();
            }
            languageSpecManager = b;
        }
        return languageSpecManager;
    }

    protected LanguageSpecManager() {
        this.initDefaultLanguageSpecs();
    }

    protected void initDefaultLanguageSpecs() {
        int n = LanguageSpec.i;
        this.a = new TreeMap<String, LanguageSpec>();
        this.registerLanguageSpec(new LanguageSpec("Java", "java", new JavaTokenMarker(), "_", "//", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("JSP", "jsp", new JavaScriptTokenMarker(), "_", "//", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("PHP", "php", new PHPTokenMarker(), "_", "//", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("Verilog", "v;verilog", new VerilogTokenMarker(), "_", "//", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("VHDL", "vhdl", new VHDLTokenMarker(), "_", "--"));
        this.registerLanguageSpec(new LanguageSpec("PLSQL", "plsql", new PLSQLTokenMarker(), "_", "--", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("TSQL", "tsql", new TSQLTokenMarker(), "_", "--", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("Perl", "pl;pm;cgi", new PerlTokenMarker(), "_", "#", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("C", "c", new CTokenMarker(), "_", "//", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("C++", "cpp;cxx", new CCTokenMarker(), "_", "#", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("HTML", "html;htm;shtml;stm;asp;asa;aspx", new HTMLTokenMarker(), "_", null, "<!--", "-->"));
        this.registerLanguageSpec(new LanguageSpec("XML", "xml", new XMLTokenMarker(), "_", null, "<!--", "-->"));
        this.registerLanguageSpec(new LanguageSpec("Python", "py", new PythonTokenMarker(), "_", "#"));
        if (n != 0) {
            CodeEditor.V = !CodeEditor.V;
        }
    }

    public LanguageSpec getLanguageSpec(String string) {
        block3: {
            Object object;
            block2: {
                object = string;
                if (LanguageSpec.i != 0) break block2;
                if (object == null) break block3;
                object = this.a.get(string);
            }
            return (LanguageSpec)object;
        }
        return null;
    }

    public LanguageSpec[] getLanguageSpecs() {
        LanguageSpec[] languageSpecArray;
        block2: {
            int n = LanguageSpec.i;
            LanguageSpec[] languageSpecArray2 = new LanguageSpec[this.a.size()];
            int n2 = 0;
            Set<String> set = this.a.keySet();
            for (String string : set) {
                languageSpecArray = languageSpecArray2;
                if (n == 0) {
                    languageSpecArray[n2] = this.a.get(string);
                    ++n2;
                    if (n == 0) continue;
                }
                break block2;
            }
            languageSpecArray = languageSpecArray2;
        }
        return languageSpecArray;
    }

    public void registerLanguageSpec(LanguageSpec languageSpec) {
        this.a.put(languageSpec.getName(), languageSpec);
    }

    public void unregisterLanguageSpec(String string) {
        this.a.remove(string);
    }
}

