/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.models.EBMClass;
import ch.e2e.builder.compiler.models.EBMCustomization;
import ch.e2e.builder.compiler.models.EBMDefaultValue;
import ch.e2e.builder.compiler.models.EBMElement;
import ch.e2e.builder.compiler.models.EBMEnumeration;
import ch.e2e.builder.compiler.models.EBMGeneralization;
import ch.e2e.builder.compiler.models.EBMHelper;
import ch.e2e.builder.compiler.models.EBMOperation;
import ch.e2e.builder.compiler.models.EBMPackage;
import ch.e2e.builder.compiler.models.EBMParameter;
import ch.e2e.builder.compiler.models.EBMProperty;
import ch.e2e.builder.compiler.models.EBMStereotype;
import ch.e2e.builder.compiler.models.EBMTypedElement;
import ch.e2e.builder.compiler.uml.ActionScript;
import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeConstraint;
import ch.e2e.builder.compiler.uml.BridgeParameterDefinition;
import ch.e2e.builder.compiler.uml.BridgeSignal;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Customization;
import ch.e2e.builder.compiler.uml.DependencyCustomization;
import ch.e2e.builder.compiler.uml.DependencySupplierDefinition;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.Documentation;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Logging;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.Multiplicity;
import ch.e2e.builder.compiler.uml.Name;
import ch.e2e.builder.compiler.uml.OperationDefinition;
import ch.e2e.builder.compiler.uml.PasswordProperty;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.PropertyCustomization;
import ch.e2e.builder.compiler.uml.PropertyDefinition;
import ch.e2e.builder.compiler.uml.SQLStatement;
import ch.e2e.builder.compiler.uml.StereotypeFactory;
import ch.e2e.builder.compiler.uml.Text;
import ch.e2e.builder.compiler.uml.ValueList;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultStereotypeFactory
extends StereotypeFactory {
    public static final String SUPPLIER = "supplier";
    public static final String DEPENDENCIES = "Dependencies";
    public static final String CHILDREN = "children";
    public static final String NAME_CUSTOMIZATION = "NameCustomization";
    public static final String DEFAULT = "default";
    public static final String PATTERN = "pattern";
    public static final String REQUIRED = "required";
    public static final String MUSTCHANGE = "mustChange";
    public static final String DOCUMENTATION_CUSTOMIZATION = "DocumentationCustomization";
    public static final String NAME_EDITABLE = "nameEditable";
    public static final String NAME_PATTERN = "namePattern";
    public static final String NAME_REQUIRED = "nameRequired";
    public static final List SKIP_PROPERTY_NAMES = Arrays.asList("base_Artifact", "base_Action", "base_Class", "base_InstanceSpecification", "call", "base_Dependency", "base_Operation", "base_Interface", "base_Signal", "base_Transition", "base_ObjectNode", "base_ObjectFlwo", "base_ControlFlow", "base_Parameter", "base_Component", "base_SendSignalAction", "base_AcceptEventAction", "base_CallOperationAction", "base_Package", "base_Property", "base_Node", "base_ObjectFlow", "base_Element", "base_SendSignalAction");
    public static final Map<String, Class> class2class = new HashMap<String, Class>();
    private HashMap<String, BridgeStereotype> stereotypesEbmId = new HashMap();
    private EBMStereotype componentCustomizationType;
    private Module bridgeProfile;

    public DefaultStereotypeFactory(Helpers helpers) {
        super(helpers);
    }

    @Override
    public BridgeStereotype findClassifierType(BridgeStereotype deploymentType) {
        return null;
    }

    @Override
    public BridgeParameterDefinition createParameterDefinition(BridgeAttribute attribute) {
        return null;
    }

    private void addSubStereotypes(EBMStereotype general, ArrayList<BridgeStereotype> typeList) {
        for (EBMGeneralization g : EBMHelper.getGeneralizationsOf((EBMElement)general)) {
            BridgeStereotype next;
            EBMElement parent = g.getParent();
            if (!(parent instanceof EBMStereotype)) continue;
            EBMStereotype stereotype = (EBMStereotype)parent;
            if (stereotype.isAbstract().booleanValue()) {
                this.addSubStereotypes(stereotype, typeList);
                continue;
            }
            if (this.isDefined(stereotype.getName())) {
                next = this.getStereotype(stereotype.getName());
            } else {
                next = this.createStereotype(stereotype);
                this.addStereotype(next);
            }
            if (typeList.contains(next)) continue;
            typeList.add(next);
            this.addSubStereotypes(stereotype, typeList);
        }
    }

    @Override
    protected ArrayList<BridgeStereotype> createStereotypeList(BridgeStereotype generalization) {
        ArrayList<BridgeStereotype> typeList = new ArrayList<BridgeStereotype>();
        EBMStereotype general = (EBMStereotype)generalization.getReference();
        this.addSubStereotypes(general, typeList);
        Object[] stereotypes = new BridgeStereotype[typeList.size()];
        typeList.toArray(stereotypes);
        Arrays.sort(stereotypes);
        return new ArrayList<Object>(Arrays.asList(stereotypes));
    }

    private void addSupplier(EBMCustomization mdCustomization, DependencyCustomization customization) {
        EBMEnumeration supplier = mdCustomization.findEnumeration(SUPPLIER);
        if (supplier != null) {
            List ownedLiteral = supplier.getOwnedLiterals();
            for (EBMElement o : ownedLiteral) {
                BridgeStereotype supplierType = this.getStereotype(o.getName());
                DependencySupplierDefinition supplierDefinition = new DependencySupplierDefinition(supplierType);
                String nodeType = supplierType.getPropertyValue("nodeType");
                if (nodeType != null) {
                    supplierDefinition.setNodeType(this.getStereotype(nodeType));
                }
                customization.addSupplierDefinition(supplierDefinition);
            }
        }
    }

    private void setSupplierTypes(EBMCustomization ebmCustomization, DependencyCustomization customization) {
        EBMStereotype dependencyCustomization = (EBMStereotype)this.getStereotype("E2EDependencyCustomization").getReference();
        try {
            if (EBMHelper.hasStereotype((EBMElement)ebmCustomization, (EBMStereotype)dependencyCustomization).booleanValue()) {
                this.addSupplier(ebmCustomization, customization);
            }
        }
        catch (IllegalArgumentException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "setSupplierTypes", e);
        }
    }

    private EBMCustomization addDependencyCustomization(BridgeStereotype stereotype) {
        EBMCustomization ebmCustomization = ((EBMStereotype)stereotype.getReference()).getCustomization();
        DependencyCustomization customization = new DependencyCustomization();
        this.createCustomization(ebmCustomization, stereotype, customization);
        if (ebmCustomization != null) {
            this.setSupplierTypes(ebmCustomization, customization);
        }
        return ebmCustomization;
    }

    BridgeStereotype createDependency(EBMStereotype ebmStereotype) {
        BridgeStereotype bridgeStereotype = this.createBridgeStereotype(ebmStereotype);
        EBMCustomization customization = this.addDependencyCustomization(bridgeStereotype);
        if (customization != null) {
            HashMap<String, PropertyDefinition> properties = this.createPropertyDefinitions(ebmStereotype, bridgeStereotype, customization);
            bridgeStereotype.setPropertyDefinitions(properties);
        }
        for (EBMGeneralization generalization : ebmStereotype.getGeneralizations()) {
            EBMStereotype general = (EBMStereotype)EBMHelper.getGeneralizationGeneral((EBMGeneralization)generalization);
            if (general == null) continue;
            bridgeStereotype.setGeneralization(this.createDependency(general));
        }
        return bridgeStereotype;
    }

    @Override
    protected BridgeStereotype createDependency(String name) {
        EBMStereotype ebmStereotype = EBMHelper.getStereotype((String)name);
        BridgeStereotype result = null;
        if (ebmStereotype == null) {
            switch (name) {
                case "FileSystemAdapterDependency": {
                    result = this.createFileSystemAdapterDependency();
                    break;
                }
                case "JMSDependency": {
                    result = this.createJMSAdapterDependency();
                    break;
                }
                case "POP3AdapterDependency": {
                    result = this.createPOP3AdapterDependency();
                    break;
                }
                case "SAPRFCAdapterDependency": {
                    result = this.createSAPRFAdapterDependency();
                    break;
                }
                case "SAPRFCGatewayDependency": {
                    result = this.createSAPRFGatewayDependency();
                    break;
                }
                case "SMTPAdapterDependency": {
                    result = this.createSMTPAdapterDependency();
                    break;
                }
                case "SOAPAdapterDependency": {
                    result = this.createSOAPAdapterDependency();
                    break;
                }
                case "SQLAdapterDependency": {
                    result = this.createSQLAdapterDependency();
                    break;
                }
                case "URLAdapterDependency": {
                    result = this.createURLAdapterDependency();
                }
            }
        } else {
            result = this.createDependency(ebmStereotype);
        }
        return result;
    }

    @Override
    public void addStereotype(BridgeStereotype stereotype) {
        super.addStereotype(stereotype);
        if (stereotype.getEbmId() != null) {
            this.stereotypesEbmId.put(stereotype.getEbmId(), stereotype);
        }
    }

    @Override
    public BridgeStereotype getStereotype(String key) {
        BridgeStereotype stereotype;
        if (key == null) {
            return null;
        }
        if (key.startsWith("ebm:")) {
            stereotype = this.stereotypesEbmId.get(key);
            if (stereotype == null && (stereotype = this.createStereotype(key)) != null) {
                this.addStereotype(stereotype);
                this.getHelpers().getPackagesFactory().setStereotypePackage(stereotype);
            }
        } else {
            stereotype = super.getStereotype(key);
        }
        return stereotype;
    }

    private BridgeStereotype createBridgeStereotype(EBMStereotype stereotype) {
        String name = stereotype.getName();
        String description = "";
        BridgeStereotype bridgeStereotype = new BridgeStereotype(name, description, this.getHelpers());
        bridgeStereotype.setReference(stereotype);
        this.addStereotype(bridgeStereotype);
        this.getHelpers().getPackagesFactory().setStereotypePackage(bridgeStereotype);
        bridgeStereotype.setModule(this.getBridgeBaseModule());
        bridgeStereotype.setXmiID(stereotype.getXmiId());
        List baseClasses = stereotype.getMetaClasses();
        for (EBMElement o : baseClasses) {
            if (!o.getHref().startsWith("uml:UML.xmi#")) continue;
            bridgeStereotype.addBaseclass(o.getHref().substring("uml:UML.xmi#".length()));
        }
        return bridgeStereotype;
    }

    protected void fillCustomizationDefaults(Customization customization) {
        customization.setElementName(new Name("", ".*", false, false));
        customization.setElementDescription(new Documentation("", false, false));
    }

    private EBMStereotype getComponentCustomizationType() {
        if (this.componentCustomizationType == null) {
            this.componentCustomizationType = EBMHelper.getStereotype((String)"E2EComponentCustomization");
        }
        return this.componentCustomizationType;
    }

    private BridgeStereotype findStereotype(EBMCustomization ebmCustomization, EBMStereotype dependencyCustomization, String tag) {
        Object value = EBMHelper.getStereotypePropertyFirst((EBMElement)ebmCustomization, (EBMStereotype)dependencyCustomization, (String)tag);
        if (value instanceof EBMStereotype) {
            return this.getStereotype((EBMStereotype)value);
        }
        return null;
    }

    private ArrayList<EBMCustomization> findAllComponentCustomizations(EBMPackage parent) {
        ArrayList<EBMCustomization> result = new ArrayList<EBMCustomization>();
        EBMStereotype customizationStereotype = this.getComponentCustomizationType();
        parent.getStereotypes();
        List suspects = parent.getStereotypes();
        for (EBMStereotype ebmStereotype : suspects) {
            EBMCustomization ebmCustomization = ebmStereotype.getCustomization();
            if (ebmCustomization == null || !EBMHelper.hasStereotype((EBMElement)ebmCustomization, (EBMStereotype)customizationStereotype).booleanValue()) continue;
            result.add(ebmCustomization);
        }
        return result;
    }

    private void setDeploymentAndClassifierType(EBMCustomization ebmCustomization, BridgeStereotype bridgeStereotype, boolean searchClassifier) {
        EBMStereotype compCustomizationType = this.getComponentCustomizationType();
        if (EBMHelper.hasStereotype((EBMElement)ebmCustomization, (EBMStereotype)compCustomizationType).booleanValue()) {
            BridgeStereotype deploymentStereotype = this.findStereotype(ebmCustomization, compCustomizationType, "deploymentType");
            if (deploymentStereotype != null) {
                bridgeStereotype.setDeploymentType(deploymentStereotype);
            }
        } else if (searchClassifier) {
            ArrayList<EBMCustomization> componentCustomizations = this.findAllComponentCustomizations((EBMPackage)ebmCustomization.getParent().getParent());
            BridgeStereotype classifierType = null;
            for (EBMCustomization componentCustomization : componentCustomizations) {
                Object value = EBMHelper.getStereotypePropertyFirst((EBMElement)componentCustomization, (EBMStereotype)compCustomizationType, (String)"deploymentType");
                if (value == null || !((EBMStereotype)value).getName().equals(bridgeStereotype.getName())) continue;
                classifierType = this.findStereotype(componentCustomization, compCustomizationType, "customizationTarget");
                break;
            }
            bridgeStereotype.setClassifierType(classifierType);
        }
    }

    private EBMProperty findProperty(EBMClass clazz, String name) {
        for (EBMProperty p : clazz.getProperties()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    private Name createNameCustomization(EBMCustomization ebmCustomization) {
        Name result;
        EBMClass nameCustomization = ebmCustomization.findClass(NAME_CUSTOMIZATION);
        if (nameCustomization != null) {
            EBMProperty defaultName = this.findProperty(nameCustomization, DEFAULT);
            String nameDefault = defaultName == null || defaultName.getDefaultValue() == null ? "" : defaultName.getDefaultValue().getValue();
            EBMProperty pattern = this.findProperty(nameCustomization, PATTERN);
            String namePattern = pattern == null || pattern.getDefaultValue() == null ? ".*" : pattern.getDefaultValue().getValue();
            EBMProperty required = this.findProperty(nameCustomization, REQUIRED);
            boolean isRequired = required != null && required.getDefaultValue() != null && Boolean.parseBoolean(required.getDefaultValue().getValue());
            EBMProperty mustChange = this.findProperty(nameCustomization, MUSTCHANGE);
            boolean isMustChange = mustChange != null && mustChange.getDefaultValue() != null && Boolean.parseBoolean(mustChange.getDefaultValue().getValue());
            EBMProperty editable = this.findProperty(nameCustomization, "editable");
            boolean isEditable = editable == null || editable.getDefaultValue() == null || Boolean.parseBoolean(editable.getDefaultValue().getValue());
            result = new Name(nameDefault, namePattern, isRequired, isMustChange, isEditable);
        } else {
            result = new Name("", ".*", false, false);
        }
        return result;
    }

    private void setDocumentationCustomization(EBMCustomization ebmCustomization, Customization customization) {
        EBMClass docCustomization = ebmCustomization.findClass(DOCUMENTATION_CUSTOMIZATION);
        if (docCustomization != null) {
            EBMProperty defaultName = this.findProperty(docCustomization, DEFAULT);
            String docDefault = defaultName == null || defaultName.getDefaultValue() == null ? "" : defaultName.getDefaultValue().getValue();
            EBMProperty required = this.findProperty(docCustomization, REQUIRED);
            boolean isRequired = required != null && required.getDefaultValue() != null && Boolean.parseBoolean(required.getDefaultValue().getValue());
            EBMProperty mustChange = this.findProperty(docCustomization, MUSTCHANGE);
            boolean isMustChange = mustChange != null && mustChange.getDefaultValue() != null && Boolean.parseBoolean(mustChange.getDefaultValue().getValue());
            customization.setElementDescription(new Documentation(docDefault, isRequired, isMustChange));
        } else {
            customization.setElementDescription(new Documentation("Please insert documentation here.", false, false));
        }
    }

    private BridgeClass createType(EBMTypedElement element) {
        BridgeClass elementType = null;
        String typeKey = element.getTypeKey();
        if (typeKey != null) {
            EBMElement type;
            if (typeKey.startsWith("uml:PrimitiveTypes.xmi#")) {
                String primitiveType = typeKey.substring("uml:PrimitiveTypes.xmi#".length());
                String bridgeTypeName = "Base Types/Any";
                switch (primitiveType) {
                    case "String": {
                        bridgeTypeName = "Base Types/String";
                        break;
                    }
                    case "Boolean": {
                        bridgeTypeName = "Base Types/Boolean";
                        break;
                    }
                    case "Integer": {
                        bridgeTypeName = "Base Types/Integer";
                        break;
                    }
                    case "Real": 
                    case "Float": {
                        bridgeTypeName = "Base Types/Float";
                    }
                }
                elementType = this.getHelpers().getElementHelper().findType(bridgeTypeName);
            } else if (typeKey.startsWith("ebm:") && (type = EBMHelper.getElement((String)typeKey)) != null) {
                elementType = type instanceof EBMEnumeration ? this.getHelpers().getElementHelper().findType("Base Types/String") : this.getHelpers().getElementHelper().getBridgeClass(type.getXmiId(), type, null);
            }
        }
        return elementType;
    }

    private Multiplicity createMultiplicity(EBMTypedElement element) {
        return this.parseMultiplicity(element.getMultiplicityValue());
    }

    protected Multiplicity parseMultiplicity(String multiplicityString) {
        Multiplicity multiplicity = null;
        if (multiplicityString != null) {
            if (multiplicityString.equals("0..1")) {
                multiplicity = Multiplicity.createMultiplicity(3);
            } else if (multiplicityString.equals("0..*")) {
                multiplicity = Multiplicity.createMultiplicity(4);
            } else if (multiplicityString.equals("1")) {
                multiplicity = Multiplicity.createMultiplicity(0);
            } else if (multiplicityString.equals("1..*")) {
                multiplicity = Multiplicity.createMultiplicity(1);
            }
        }
        return multiplicity;
    }

    private BridgeStereotype getStereotype(EBMStereotype stereotype) {
        BridgeStereotype bridgeStereotype;
        if (this.isDefined(stereotype.getName())) {
            bridgeStereotype = this.getStereotype(stereotype.getName());
        } else {
            bridgeStereotype = this.createStereotype(stereotype);
            this.addStereotype(bridgeStereotype);
        }
        return bridgeStereotype;
    }

    private BridgeParameterDefinition createParameterDefinition(EBMParameter parameter) {
        String name = parameter.getName();
        BridgeClass types = this.createType((EBMTypedElement)parameter);
        Multiplicity multiplicity = this.createMultiplicity((EBMTypedElement)parameter);
        BridgeParameterDefinition paramDef = new BridgeParameterDefinition(name, types, Direction.getDirection(parameter.getDirection()), multiplicity, null, this.getHelpers());
        List stereotypes = EBMHelper.getStereotypes((EBMElement)parameter);
        for (EBMStereotype stereotype : stereotypes) {
            BridgeStereotype bridgeStereotype = this.getStereotype(stereotype);
            paramDef.addStereotype(bridgeStereotype);
            for (PropertyDefinition property : bridgeStereotype.getPropertyDefinitions().values()) {
                Object value = EBMHelper.getStereotypePropertyFirst((EBMElement)parameter, (EBMStereotype)stereotype, (String)property.getName());
                if (!(value instanceof EBMClass)) continue;
                EBMClass clazz = (EBMClass)value;
                BridgeClass bridgeClazz = this.getHelpers().getElementHelper().getBridgeClass(clazz.getXmiId(), clazz, null);
                paramDef.setPropertyValueQuietly(property.getName(), bridgeClazz);
            }
        }
        return paramDef;
    }

    private BridgeConstraint findFirstBridgeConstraint(EBMElement ebmElement) {
        return null;
    }

    private OperationDefinition createOperationDefinition(EBMOperation ebmOperation) {
        String name = ebmOperation.getName();
        EBMStereotype e2eOperation = EBMHelper.getStereotype((String)"E2EOperation");
        Boolean editable = (Boolean)EBMHelper.getStereotypePropertyFirst((EBMElement)ebmOperation, (EBMStereotype)e2eOperation, (String)NAME_EDITABLE);
        editable = editable == null ? true : editable;
        Boolean required = (Boolean)EBMHelper.getStereotypePropertyFirst((EBMElement)ebmOperation, (EBMStereotype)e2eOperation, (String)NAME_REQUIRED);
        required = required == null ? true : required;
        String pattern = (String)EBMHelper.getStereotypePropertyFirst((EBMElement)ebmOperation, (EBMStereotype)e2eOperation, (String)NAME_REQUIRED);
        pattern = pattern == null ? ".*" : pattern;
        Name nameCustomization = new Name(name, pattern, required, false, editable);
        List parameters = ebmOperation.getParameters();
        ArrayList<BridgeParameterDefinition> bridgeParamDefs = new ArrayList<BridgeParameterDefinition>();
        for (EBMParameter p : parameters) {
            bridgeParamDefs.add(this.createParameterDefinition(p));
        }
        return new OperationDefinition(nameCustomization, bridgeParamDefs, this.findFirstBridgeConstraint((EBMElement)ebmOperation));
    }

    private String getDefaultValue(EBMProperty property) {
        String valueStr = null;
        EBMDefaultValue value = property.getDefaultValue();
        if (value != null) {
            String type;
            valueStr = value.getValue();
            String string = type = value.getType() != null ? value.getType() : "uml:LiteralString";
            if (type.equals("uml:InstanceValue")) {
                if (value.getInstance() != null) {
                    String href = value.getInstance().getHref();
                    if (property.getType() instanceof EBMEnumeration) {
                        EBMElement element = EBMHelper.getElement((String)href);
                        if (element != null) {
                            valueStr = element.getName();
                        }
                    } else {
                        valueStr = href;
                    }
                }
            } else if (type.equals("uml:ElementValue")) {
                valueStr = value.getElement() != null ? value.getElement().getHref() : null;
            } else if (type.equals("uml:LiteralString")) {
                valueStr = value.getValue().equals("$EMPTY_STRING$") ? "" : value.getValue();
            }
        }
        return valueStr;
    }

    private Object createValue(String value, String type) {
        Object result = type.equals("uml:PrimitiveTypes.xmi#Boolean") ? Boolean.valueOf(value) : (type.equals("uml:PrimitiveTypes.xmi#Integer") ? Integer.valueOf(value) : value);
        return result;
    }

    private void addChildren(EBMCustomization ebmCustomization, Customization customization) {
        EBMEnumeration children = null;
        for (EBMEnumeration ebmEnumeration : ebmCustomization.getEnumerations()) {
            if (!ebmEnumeration.getName().equals(CHILDREN)) continue;
            children = ebmEnumeration;
            break;
        }
        if (children != null) {
            for (EBMElement o : children.getOwnedLiterals()) {
                customization.addChild(this.getStereotype(o.getName()));
            }
        }
    }

    private void addDependencies(EBMCustomization ebmCustomization, Customization customization) {
        EBMEnumeration dependencies = null;
        for (EBMEnumeration ebmEnumeration : ebmCustomization.getEnumerations()) {
            if (!ebmEnumeration.getName().equals(DEPENDENCIES)) continue;
            dependencies = ebmEnumeration;
            break;
        }
        if (dependencies != null) {
            for (EBMElement o : dependencies.getOwnedLiterals()) {
                customization.addBridgeDependency(this.getDependency(o.getName()));
            }
        }
    }

    private void fillCustomization(EBMCustomization ebmCustomization, Customization customization) {
        customization.setElementName(this.createNameCustomization(ebmCustomization));
        this.setDocumentationCustomization(ebmCustomization, customization);
        for (EBMOperation op : ebmCustomization.getOperations()) {
            customization.addOperationDefinition(this.createOperationDefinition(op));
        }
        for (EBMProperty property : ebmCustomization.getProperties()) {
            customization.addProperty(property.getName(), this.createValue(this.getDefaultValue(property), property.getTypeKey()));
        }
        this.addChildren(ebmCustomization, customization);
        this.addDependencies(ebmCustomization, customization);
    }

    private void createCustomization(EBMCustomization ebmCustomization, BridgeStereotype bridgeStereotype, Customization customization) {
        if (ebmCustomization == null) {
            this.fillCustomizationDefaults(customization);
        } else {
            this.setDeploymentAndClassifierType(ebmCustomization, bridgeStereotype, !(customization instanceof DependencyCustomization));
            this.fillCustomization(ebmCustomization, customization);
        }
        bridgeStereotype.setCustomization(customization);
    }

    private EBMCustomization addCustomization(BridgeStereotype bridgeStereotype, EBMStereotype stereotype) {
        EBMCustomization ebmCustomization = stereotype.getCustomization();
        Customization customization = new Customization();
        this.createCustomization(ebmCustomization, bridgeStereotype, customization);
        return ebmCustomization;
    }

    private Class findEnumerationType(EBMEnumeration enumeration) {
        Class type = class2class.get("String");
        return type;
    }

    private PropertyDefinition createPropertyDefinition(String name, Class type, EBMProperty property) {
        PropertyDefinition propDef = new PropertyDefinition(name, type, this.createType((EBMTypedElement)property));
        Multiplicity multiplicity = this.createMultiplicity((EBMTypedElement)property);
        propDef.setMultiplicity(multiplicity);
        return propDef;
    }

    private PropertyDefinition createEnumerationPropertyDefinition(EBMProperty ebmProperty) {
        PropertyDefinition propDef = null;
        EBMEnumeration enumeration = (EBMEnumeration)ebmProperty.getType();
        List values = enumeration.getOwnedLiterals();
        Class type = this.findEnumerationType(enumeration);
        if (type != null) {
            ValueList valueList = new ValueList(type, true, this.getHelpers());
            for (EBMElement value : values) {
                valueList.add(value.getName());
            }
            propDef = this.createPropertyDefinition(ebmProperty.getName(), type, ebmProperty);
            String defaultValue = this.getDefaultValue(ebmProperty);
            if (defaultValue != null) {
                valueList.setDefaultValue(defaultValue);
            }
            propDef.setValues(valueList);
        }
        return propDef;
    }

    private PropertyDefinition createArtifactPropertyDefinition(EBMProperty property) {
        PropertyDefinition propDef = new PropertyDefinition(property.getName(), DeploymentElement.class, this.createType((EBMTypedElement)property));
        Multiplicity multiplicity = this.createMultiplicity((EBMTypedElement)property);
        ValueList list = new ValueList(DeploymentElement.class, true, this.getHelpers());
        propDef.setValues(list);
        propDef.setMultiplicity(multiplicity);
        return propDef;
    }

    private PropertyDefinition createPropertyDefinition(EBMProperty ebmProperty) {
        PropertyDefinition propDef = null;
        String typeName = ebmProperty.getTypeName();
        if (typeName != null) {
            if (typeName.equals("Artifact")) {
                propDef = this.createArtifactPropertyDefinition(ebmProperty);
            } else {
                EBMElement propertyType = ebmProperty.getType();
                if (propertyType instanceof EBMStereotype) {
                    propDef = this.createPropertyDefinition(ebmProperty.getName(), BridgeClass.class, ebmProperty);
                    propDef.addStereotype(this.createStereotype((EBMStereotype)propertyType));
                } else {
                    propDef = this.createPropertyDefinition(ebmProperty.getName(), class2class.get(typeName), ebmProperty);
                }
                if (ebmProperty.getDefaultValue() != null) {
                    propDef.setDefaultValue(this.getDefaultValue(ebmProperty));
                }
            }
        }
        return propDef;
    }

    private void addEditDependencies(EBMClass propCustomization, PropertyCustomization customization) {
        EBMClass editableIf = propCustomization.findClass("EditableIf");
        if (editableIf != null) {
            for (EBMEnumeration enumeration : editableIf.getEnumerations()) {
                Class type = this.findEnumerationType(enumeration);
                for (EBMElement value : enumeration.getOwnedLiterals()) {
                    customization.addPropertyEditable(enumeration.getName(), this.getHelpers().getElementHelper().createValue(value.getName(), type));
                }
            }
        }
    }

    private void addIgnoreDependencies(EBMClass propCustomization, PropertyCustomization customization) {
        EBMClass ignoreIf = propCustomization.findClass("IgnoreIf");
        if (ignoreIf != null) {
            for (EBMEnumeration enumeration : ignoreIf.getEnumerations()) {
                Class type = this.findEnumerationType(enumeration);
                ArrayList<Object> ignoreValues = new ArrayList<Object>();
                for (EBMElement value : enumeration.getOwnedLiterals()) {
                    ignoreValues.add(this.getHelpers().getElementHelper().createValue(value.getName(), type));
                }
                customization.setPropertyIgnoreValues(enumeration.getName(), ignoreValues);
            }
        }
    }

    private void addDefaultValueDependencies(EBMClass propCustomization, PropertyCustomization customization) {
        EBMClass defaultIf = propCustomization.findClass("DefaultValueIf");
        if (defaultIf != null) {
            for (EBMEnumeration enumeration : defaultIf.getEnumerations()) {
                Class type = this.findEnumerationType(enumeration);
                for (EBMProperty value : enumeration.getProperties()) {
                    customization.addPropertyDefault(enumeration.getName(), this.getHelpers().getElementHelper().createValue(value.getName(), type), this.createValue(this.getDefaultValue(value), value.getType().getName()));
                }
            }
        }
    }

    private void fillPropertyCustomization(EBMClass propCustomization, PropertyDefinition propDef) {
        String groupObj = EBMHelper.getStereotypePropertyFirst((EBMElement)propCustomization, (EBMStereotype)EBMHelper.getStereotype((String)"E2ETaggedValueCustomization"), (String)"group").toString();
        String group = groupObj != null ? groupObj.toString() : "";
        propDef.setGroup(group);
        String indexObj = EBMHelper.getStereotypePropertyFirst((EBMElement)propCustomization, (EBMStereotype)EBMHelper.getStereotype((String)"E2ETaggedValueCustomization"), (String)"index").toString();
        if (indexObj != null) {
            try {
                propDef.setIndex(Integer.parseInt(indexObj.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        PropertyCustomization customization = new PropertyCustomization();
        this.addEditDependencies(propCustomization, customization);
        this.addIgnoreDependencies(propCustomization, customization);
        this.addDefaultValueDependencies(propCustomization, customization);
        propDef.setCustomization(customization);
    }

    private PropertyDefinition createPropertyDefinition(EBMProperty ebmProperty, EBMCustomization customization) {
        PropertyDefinition propDef = null;
        EBMElement type = ebmProperty.getType();
        if (ebmProperty.getTypeKey() != null && (propDef = type != null && type instanceof EBMEnumeration ? this.createEnumerationPropertyDefinition(ebmProperty) : this.createPropertyDefinition(ebmProperty)) != null && customization != null) {
            List stereotypes = EBMHelper.getStereotypes((EBMElement)ebmProperty);
            for (EBMStereotype stereotype : stereotypes) {
                propDef.addStereotype(this.getStereotype(stereotype.getName()));
            }
            EBMClass propCustomization = customization.findClass(ebmProperty.getName());
            if (propCustomization != null) {
                for (EBMProperty custProperty : propCustomization.getProperties()) {
                    if (custProperty.getName().equals("min")) {
                        try {
                            propDef.setMinValue(NumberFormat.getInstance().parse(custProperty.getDefaultValue() == null ? "" : custProperty.getDefaultValue().getValue()));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (custProperty.getName().equals("max")) {
                        propDef.setMaxValue(Integer.parseInt(custProperty.getDefaultValue() == null ? "" : custProperty.getDefaultValue().getValue()));
                        continue;
                    }
                    if (custProperty.getName().equals(PATTERN)) {
                        propDef.setPattern(custProperty.getDefaultValue() == null ? "" : custProperty.getDefaultValue().getValue());
                        continue;
                    }
                    if (custProperty.getName().equals("visible")) {
                        propDef.setVisible(Boolean.parseBoolean(custProperty.getDefaultValue() == null ? "" : custProperty.getDefaultValue().getValue()));
                        continue;
                    }
                    if (custProperty.getName().equals("editable")) {
                        propDef.setEditable(Boolean.parseBoolean(custProperty.getDefaultValue() == null ? "" : custProperty.getDefaultValue().getValue()));
                        continue;
                    }
                    if (!custProperty.getName().equals("allwaysShowDefault")) continue;
                    propDef.setAllwaysShowDefault(Boolean.parseBoolean(custProperty.getDefaultValue() == null ? "" : custProperty.getDefaultValue().getValue()));
                }
                this.fillPropertyCustomization(propCustomization, propDef);
            }
        }
        return propDef;
    }

    private HashMap<String, PropertyDefinition> createPropertyDefinitions(EBMStereotype ebmStereotype, BridgeStereotype bridgeStereotype, EBMCustomization ebmCustomization) {
        PropertyDefinition propertyDefinition;
        Map propertiesMap = EBMHelper.getPropertiesIncludingParents((EBMStereotype)ebmStereotype);
        List stereotypeProperties = (List)propertiesMap.get(ebmStereotype);
        propertiesMap.remove(ebmStereotype);
        HashMap<String, EBMProperty> properties = new HashMap<String, EBMProperty>();
        for (EBMProperty property : stereotypeProperties) {
            properties.put(property.getName(), property);
        }
        for (List list : propertiesMap.values()) {
            for (EBMProperty property : list) {
                if (properties.containsKey(property.getName())) continue;
                properties.put(property.getName(), property);
            }
        }
        HashMap<String, PropertyDefinition> propertyDefs = new HashMap<String, PropertyDefinition>();
        for (EBMProperty p : properties.values()) {
            if (!SKIP_PROPERTY_NAMES.contains(p.getName()) && !p.isReadOnly().booleanValue()) {
                if (propertyDefs.containsKey(p.getName()) && !p.getParent().equals(ebmStereotype) || (propertyDefinition = this.createPropertyDefinition(p, ebmCustomization)) == null) continue;
                bridgeStereotype.getCustomization().addPropertyDefinition(propertyDefinition);
                propertyDefs.put(p.getName(), propertyDefinition);
                continue;
            }
            if (!p.isReadOnly().booleanValue()) continue;
            PropertyDefinition propertyDef = p.getType() instanceof EBMEnumeration ? this.createEnumerationPropertyDefinition(p) : this.createPropertyDefinition(p);
            bridgeStereotype.addProperty(new Property(propertyDef));
        }
        if (bridgeStereotype.getCustomization().getProperty("usedUMLProperties") != null) {
            for (Object value : (Collection)bridgeStereotype.getCustomization().getProperty("usedUMLProperties")) {
                if (!value.equals("signal")) continue;
                propertyDefinition = new PropertyDefinition("Signal", BridgeSignal.class);
                propertyDefinition.setMultiplicity(Multiplicity.createMultiplicity(1, 1));
                propertyDefinition.setStandardUmlProperty(true);
                bridgeStereotype.getCustomization().addPropertyDefinition(propertyDefinition);
                propertyDefs.put("Signal", propertyDefinition);
            }
        }
        return propertyDefs;
    }

    private BridgeStereotype createStereotype(EBMStereotype stereotype) {
        if (this.isDefined(stereotype.getName())) {
            return this.getStereotype(stereotype.getName());
        }
        BridgeStereotype bridgeStereotype = this.createBridgeStereotype(stereotype);
        this.addStereotype(bridgeStereotype);
        EBMCustomization customization = this.addCustomization(bridgeStereotype, stereotype);
        for (EBMGeneralization generalization : stereotype.getGeneralizations()) {
            bridgeStereotype.setGeneralization(this.getStereotype(generalization.getGeneralKey()));
        }
        HashMap<String, PropertyDefinition> properties = this.createPropertyDefinitions(stereotype, bridgeStereotype, customization);
        bridgeStereotype.setPropertyDefinitions(properties);
        return bridgeStereotype;
    }

    @Override
    protected BridgeStereotype createStereotype(String name) {
        EBMStereotype stereotype = EBMHelper.getStereotype((String)name);
        if (stereotype != null) {
            return this.createStereotype(stereotype);
        }
        return null;
    }

    private Module getBridgeBaseModule() {
        if (this.bridgeProfile == null) {
            this.bridgeProfile = this.getHelpers().getModuleFactory().getModule(new File("/<install.root>/profiles/E2E Bridge Profile.xml"), "E2E Bridge Profile.xml");
            this.bridgeProfile.addMountPointId("e2e_bridge_profile");
            this.getHelpers().getPackagesFactory().getPackage("E2E Bridge Profile").setXmiID("e2e_bridge_profile");
        }
        return this.bridgeProfile;
    }

    private BridgeStereotype createDependency(String name, Boolean required, String supplierName, String supplierNodeTypeName) {
        BridgeStereotype dependency = this.createBridgeDependency(name);
        dependency.getCustomization().addProperty(REQUIRED, required);
        DependencyCustomization customization = (DependencyCustomization)dependency.getCustomization();
        DependencySupplierDefinition supplier = new DependencySupplierDefinition(this.getStereotype(supplierName));
        supplier.setNodeType(this.getStereotype(supplierNodeTypeName));
        customization.addSupplierDefinition(supplier);
        return dependency;
    }

    private BridgeStereotype createFileSystemAdapterDependency() {
        return this.createDependency("FileSystemAdapterDependency", false, "FileSystemDeployment", "BackendServerInstance");
    }

    private BridgeStereotype createJMSAdapterDependency() {
        return this.createDependency("JMSDependency", true, "JMSDestinationDeployment", "BackendServerInstance");
    }

    private BridgeStereotype createPOP3AdapterDependency() {
        return this.createDependency("POP3AdapterDependency", true, "POP3AccountDeployment", "BackendServerInstance");
    }

    private BridgeStereotype createSAPRFAdapterDependency() {
        return this.createDependency("SAPRFCModuleDependency", false, "SAPRFCModuleInterfaceDeployment", "BackendServerInstance");
    }

    private BridgeStereotype createSAPRFGatewayDependency() {
        return this.createDependency("SAPRFCGatewayDependency", true, "SAPRFGatewayDeployment", "BackendServerInstance");
    }

    private BridgeStereotype createSMTPAdapterDependency() {
        return this.createDependency("SMTPAdapterDependency", true, "SMTPAccountDeployment", "BackendServerInstance");
    }

    private BridgeStereotype createSOAPAdapterDependency() {
        return this.createDependency("SOAPAdapterDependency", true, "SOAPPortTypeDeployment", "BackendServerInstance");
    }

    private BridgeStereotype createSQLAdapterDependency() {
        return this.createDependency("SQLAdapterDependency", true, "SQLDatabaseDeployment", "BackendServerInstance");
    }

    private BridgeStereotype createURLAdapterDependency() {
        return this.createDependency("URLAdapterDependency", true, "URLDeployment", "BackendServerInstance");
    }

    private BridgeStereotype createBridgeDependency(String name) {
        BridgeStereotype stereotype = new BridgeStereotype(name, "", this.getHelpers());
        DependencyCustomization customization = new DependencyCustomization();
        customization.setElementName(new Name("", ".*", true, false));
        Documentation documentation = new Documentation("Please enter documentation here", false, false);
        customization.setElementDescription(documentation);
        stereotype.setCustomization(customization);
        return stereotype;
    }

    static {
        class2class.put("Stereotype", String.class);
        class2class.put("String", String.class);
        class2class.put("Integer", Integer.class);
        class2class.put("int", Integer.class);
        class2class.put("double", Double.class);
        class2class.put("float", Double.class);
        class2class.put("Float", Double.class);
        class2class.put("Boolean", Boolean.class);
        class2class.put("boolean", Boolean.class);
        class2class.put("ActionScript", ActionScript.class);
        class2class.put("SQLStatement", SQLStatement.class);
        class2class.put("Classifier", ClassifierElement.class);
        class2class.put("Password", PasswordProperty.class);
        class2class.put("Interface", BridgeClass.class);
        class2class.put("Class", BridgeClass.class);
        class2class.put("Signal", BridgeClass.class);
        class2class.put("Text", Text.class);
    }
}

