/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgeUsage
extends UmlElement {
    private final UmlElement supplier;
    private final UmlElement client;

    public BridgeUsage(String name, UmlElement client, UmlElement supplier, Helpers helpers) {
        super(name, (Comment)null, helpers);
        this.supplier = supplier;
        this.client = client;
        this.setBaseclass("Usage");
    }

    public UmlElement getSupplier() {
        return this.supplier;
    }

    public UmlElement getClient() {
        return this.client;
    }

    @Override
    public void createReference() throws Exception {
        if (this.client instanceof BridgeClass && this.supplier instanceof BridgeClass) {
            this.getHelpers().getElementHelper().createUsageReference(this);
            ((BridgeClass)this.client).addUsedClass(this.getName(), (BridgeClass)this.supplier);
        }
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element result = super.toXMI(ownerDocument, xmiIDFactory);
        Element clientElt = ownerDocument.createElement("client");
        clientElt.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.client.getXmiID());
        result.appendChild(clientElt);
        Element supplierElt = ownerDocument.createElement("supplier");
        supplierElt.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.supplier.getXmiID());
        result.appendChild(supplierElt);
        return result;
    }
}

