/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.mdui;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.document.importer.ImportException;
import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.ScriptImportTransaction;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import java.io.File;
import org.w3c.dom.Document;

public class MDUIImportTransaction
extends ScriptImportTransaction {
    public static final String MDUI_IMPORT_MODEL = "mdui.import.model";
    public static final String MD_UI_DOCUMENT_SOURCE = "mdui.document.source";
    public static final String IMPORTER_NAME = "mdui2xmi";

    @Override
    public void doTransaction(ImporterData importerData) {
        if (importerData.getDestination() != null) {
            File srcFile = (File)importerData.getSource(MD_UI_DOCUMENT_SOURCE);
            try {
                Document model = this.transformMDImportDocument(srcFile, importerData.getFilename(), IMPORTER_NAME);
                ImportModel importModel = new ImportModel(importerData.getFilename());
                importModel.setDestination(new File(CompilerConstants.getSourceFolder(), importerData.getFilename()));
                importModel.setModel(model);
                importerData.addSource(MDUI_IMPORT_MODEL, importModel);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportException(ex));
            }
        }
    }
}

