/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.compiler.document.importer.java.Completable;
import ch.e2e.builder.compiler.document.importer.java.ElementParent;
import ch.e2e.builder.compiler.document.importer.java.ImportClassLoader;
import ch.e2e.builder.compiler.document.importer.java.JavaClass;
import ch.e2e.builder.compiler.document.importer.java.JavaTypeNotSupportedException;
import ch.e2e.builder.compiler.document.importer.java.Parameter;
import ch.e2e.builder.compiler.document.importer.java.TypeInfo;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.BridgeParameter;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.builder.jdp.ast.MethodDeclaration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class Operation
extends BridgeOperation
implements ElementParent {
    private ArrayList exceptions = new ArrayList();
    private ArrayList<String> paramNames = new ArrayList();
    private String classname;

    public Operation(Constructor<?> constructor, String classname, JavaClass declaringClass, ImportClassLoader classLoader, Helpers helpers) throws JavaTypeNotSupportedException {
        this(classname, classname, constructor.getDeclaringClass().getName(), constructor.getParameterTypes(), classLoader, helpers);
        this.addParameter(new Parameter(null, TypeInfo.getTypeInfo(declaringClass, classLoader), Direction.RETURN, this, helpers));
    }

    public Operation(Method method, String classname, ImportClassLoader classLoader, Helpers helpers) throws JavaTypeNotSupportedException {
        this(method.getName(), classname, method.getDeclaringClass().getName(), method.getParameterTypes(), classLoader, helpers);
        this.setStatic(Modifier.isStatic(method.getModifiers()));
        if (Modifier.isPublic(method.getModifiers())) {
            this.setVisibility("public");
        } else if (Modifier.isProtected(method.getModifiers())) {
            this.setVisibility("protected");
        } else if (Modifier.isPrivate(method.getModifiers())) {
            this.setVisibility("private");
        } else {
            this.setVisibility("package");
        }
        if (!method.getReturnType().getName().equals("void")) {
            TypeInfo typeInfo = TypeInfo.getTypeInfo(method.getReturnType(), classLoader);
            if (typeInfo == null) {
                throw new JavaTypeNotSupportedException("The return parameter type '" + method.getReturnType().getName() + "' of operation '" + method.getName() + "' is not supported");
            }
            this.addParameter(new Parameter(null, typeInfo, Direction.RETURN, this, helpers));
        }
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.getAllChildren().indexOf(child);
    }

    private Operation(String name, String classname, String fullClassname, Class<?>[] parameters, ImportClassLoader classLoader, Helpers helpers) throws JavaTypeNotSupportedException {
        super(name, new Comment("", helpers), helpers);
        this.classname = classname;
        int length = parameters.length;
        if (length > 0) {
            List<MethodDeclaration> methodDeclarations = classLoader.getMethodDeclarations(fullClassname);
            MethodDeclaration methodDeclaration = this.findMethodDeclaration(name, parameters, methodDeclarations);
            List formalParameters = null;
            if (methodDeclaration != null) {
                String description = methodDeclaration.getDescription();
                if (description != null && description.length() > 0) {
                    this.setDescription(new Comment("<html>" + description + "</html>", helpers));
                }
                formalParameters = methodDeclaration.getParameters();
            }
            for (int i = 0; i < length; ++i) {
                Class<?> anParameter = parameters[i];
                String paramName = anParameter.getName();
                TypeInfo typeInfo = TypeInfo.getTypeInfo(anParameter, classLoader);
                if (typeInfo == null) {
                    throw new JavaTypeNotSupportedException("The parameter type '" + paramName + "' in operation '" + name + "' is not supported");
                }
                paramName = formalParameters == null ? this.findParameterName(paramName, typeInfo) : ((ch.e2e.builder.jdp.ast.Parameter)formalParameters.get(i)).getName();
                Parameter parameter = new Parameter(paramName, typeInfo, Direction.IN, this, helpers);
                this.addParameter(parameter);
            }
        }
    }

    private MethodDeclaration findMethodDeclaration(String operationName, Class<?>[] parameters, List<? extends MethodDeclaration> methodDeclarations) {
        MethodDeclaration result = null;
        int length = parameters.length;
        for (MethodDeclaration methodDeclaration : methodDeclarations) {
            List formalParameters = methodDeclaration.getParameters();
            if (formalParameters.size() != length || !methodDeclaration.getName().equals(operationName)) continue;
            boolean matches = true;
            for (int i = 0; matches && i < length; ++i) {
                ch.e2e.builder.jdp.ast.Parameter fp = (ch.e2e.builder.jdp.ast.Parameter)formalParameters.get(i);
                Class<?> p = parameters[i];
                String formalType = fp.getType();
                String type = p.getSimpleName();
                matches = type.equals(formalType.toString());
            }
            if (!matches) continue;
            result = methodDeclaration;
            break;
        }
        return result;
    }

    public String getClassname() {
        return this.classname;
    }

    public ArrayList getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getKey(Completable child) {
        String key = child.equals(this.getReturnType()) ? "operation.returntype" : "operation";
        return key;
    }

    @Override
    public void addParameter(BridgeParameter parameter) {
        super.addParameter(parameter);
        if (parameter.getDirection().equals((Object)Direction.RETURN)) {
            parameter.setName("return");
        }
    }

    @Override
    public void setParameters(ArrayList<UmlElement> parameters) {
        super.setParameters(parameters);
        for (UmlElement parameter : parameters) {
            if (!((BridgeParameter)parameter).getDirection().equals((Object)Direction.RETURN)) continue;
            parameter.setName("return");
        }
    }

    private String findParameterName(String paramName, TypeInfo typeInfo) {
        int index;
        BridgeClass bridgeType = typeInfo.getBridgeType();
        BridgeClass blobType = this.getHelpers().getElementHelper().findBaseType("Base Types/Blob", null);
        if ((typeInfo.isArray() || bridgeType != null && bridgeType.equals(blobType)) && paramName.indexOf(91) != -1) {
            if (typeInfo.getNativeArrayElement() == null) {
                if (typeInfo.getArrayElement() instanceof JavaClass) {
                    paramName = ((JavaClass)typeInfo.getArrayElement()).getFullName() + 's';
                }
            } else {
                paramName = typeInfo.getNativeArrayElement() + 's';
            }
        }
        if ((index = paramName.lastIndexOf(46)) == -1) {
            paramName = this.findName("p" + Character.toUpperCase(paramName.charAt(0)) + paramName.substring(1));
        } else {
            paramName = paramName.substring(index + 1);
            paramName = this.findName(Character.toLowerCase(paramName.charAt(0)) + paramName.substring(1));
        }
        return paramName;
    }

    private String findName(String name) {
        if (name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2) + "s";
        }
        String paramName = name;
        int i = 0;
        while (this.paramNames.contains(paramName)) {
            paramName = name + '_' + String.valueOf(++i);
        }
        this.paramNames.add(paramName);
        return paramName;
    }
}

