/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.compiler.document.importer.java.ClassParserException;
import ch.e2e.builder.compiler.document.importer.java.ClassPool;
import ch.e2e.builder.compiler.document.importer.java.ParserConstants;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class ClassParser
implements ParserConstants {
    public ClassPool parse(byte[] bytes) throws IOException, ClassParserException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(is);
        this.readMagic(in);
        this.readVersion(in);
        ClassPool pool = this.readClassPool(in);
        in.close();
        return pool;
    }

    private void readMagic(DataInputStream in) throws ClassParserException, IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new ClassParserException("Invalid Magic Number");
        }
    }

    private void readVersion(DataInputStream in) throws ClassParserException, IOException {
        short minor = in.readShort();
        short major = in.readShort();
        if (!this.supportedMajorMinor(major, minor)) {
            throw new ClassParserException("(Major: " + major + ", Minor: " + minor + ") version not supported");
        }
    }

    private boolean supportedMajorMinor(short major, short minor) {
        if (major == 45) {
            return minor >= 3;
        }
        return major >= 46 && major <= 48;
    }

    private ClassPool readClassPool(DataInputStream in) throws IOException, ClassParserException {
        short entryCount = in.readShort();
        ClassPool pool = new ClassPool(entryCount);
        this.readCpEntries(in, entryCount, pool);
        return pool;
    }

    private void readCpEntries(DataInputStream in, int entryCount, ClassPool pool) throws IOException, ClassParserException {
        pool.addNullEntry();
        block13: for (int i = 1; i < entryCount; ++i) {
            byte tagByte = in.readByte();
            switch (tagByte) {
                case 1: {
                    this.readTagUtf8(in, pool);
                    continue block13;
                }
                case 3: {
                    this.readTagInteger(in, pool);
                    continue block13;
                }
                case 4: {
                    this.readTagFloat(in, pool);
                    continue block13;
                }
                case 5: {
                    this.readTagLong(in, pool);
                    ++i;
                    continue block13;
                }
                case 6: {
                    this.readTagDouble(in, pool);
                    ++i;
                    continue block13;
                }
                case 7: {
                    this.readTagClass(in, pool);
                    continue block13;
                }
                case 8: {
                    this.readTagString(in, pool);
                    continue block13;
                }
                case 9: {
                    this.readTagFieldRef(in, pool);
                    continue block13;
                }
                case 10: {
                    this.readTagMethodRef(in, pool);
                    continue block13;
                }
                case 11: {
                    this.readTagInterfaceRef(in, pool);
                    continue block13;
                }
                case 12: {
                    this.readTagNameType(in, pool);
                    continue block13;
                }
                default: {
                    throw new ClassParserException("TagByte " + tagByte + " Invalid for ConstantPool Entry #" + i);
                }
            }
        }
    }

    private void readTagUtf8(DataInputStream in, ClassPool pool) throws IOException {
        String utfString = in.readUTF();
        pool.addUtf8Entry(utfString);
    }

    private void readTagInteger(DataInputStream in, ClassPool pool) throws IOException {
        int intValue = in.readInt();
        pool.addIntegerEntry(String.valueOf(intValue));
    }

    private void readTagFloat(DataInputStream in, ClassPool pool) throws IOException {
        float floatValue = in.readFloat();
        pool.addFloatEntry(String.valueOf(floatValue) + "f");
    }

    private void readTagLong(DataInputStream in, ClassPool pool) throws IOException {
        long longValue = in.readLong();
        pool.addLongEntry(String.valueOf(longValue) + "L");
        pool.addNullEntry();
    }

    private void readTagDouble(DataInputStream in, ClassPool pool) throws IOException {
        double doubleValue = in.readDouble();
        pool.addDoubleEntry(String.valueOf(doubleValue));
        pool.addNullEntry();
    }

    private void readTagClass(DataInputStream in, ClassPool pool) throws IOException {
        short classIndex = in.readShort();
        pool.addClassEntry(classIndex);
    }

    private void readTagString(DataInputStream in, ClassPool pool) throws IOException {
        short stringIndex = in.readShort();
        pool.addStringEntry(stringIndex);
    }

    private void readTagFieldRef(DataInputStream in, ClassPool pool) throws IOException {
        short classIndex = in.readShort();
        short nameType = in.readShort();
        pool.addFieldRefEntry(classIndex, nameType);
    }

    private void readTagMethodRef(DataInputStream in, ClassPool pool) throws IOException {
        short classIndex = in.readShort();
        short nameType = in.readShort();
        pool.addMethodRefEntry(classIndex, nameType);
    }

    private void readTagInterfaceRef(DataInputStream in, ClassPool pool) throws IOException {
        short classIndex = in.readShort();
        short nameType = in.readShort();
        pool.addInterfaceRefEntry(classIndex, nameType);
    }

    private void readTagNameType(DataInputStream in, ClassPool pool) throws IOException {
        short nameIndex = in.readShort();
        short descIndex = in.readShort();
        pool.addNameTypeEntry(nameIndex, descIndex);
    }
}

