/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.idoc;

import ch.e2e.builder.compiler.document.importer.idoc.DocumentationParser;
import ch.e2e.builder.compiler.document.importer.idoc.FieldMeta;
import ch.e2e.builder.compiler.document.importer.idoc.IDocObject;
import ch.e2e.event.Logging;
import java.util.HashMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Field
extends IDocObject
implements Logging {
    private String segmentName;
    private HashMap attributes = new HashMap();
    private FieldMeta fieldMeta;
    private String nativeType;
    private String name;

    public Field(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            try {
                this.setAttribute(child.getNodeName(), child.getFirstChild().getNodeValue());
                continue;
            }
            catch (Exception e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        this.name = (String)this.attributes.get("name".toUpperCase());
    }

    public void setSegmentName(String segmentName) {
        this.segmentName = segmentName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getStereotype() {
        return null;
    }

    @Override
    public void applyFieldMeta(DocumentationParser documentationParser) {
        this.fieldMeta = documentationParser.getFieldMeta(this.segmentName, this.name);
        if (this.fieldMeta == null) {
            logger.warning("found no FieldMeta for Field named '" + this.name + "'");
        }
    }

    public FieldMeta getFieldMeta() {
        return this.fieldMeta;
    }

    private String getAttribute(String name) {
        return (String)this.attributes.get(name.toUpperCase());
    }

    public int getOffset() {
        int offset = -1;
        String offsetString = this.getAttribute("OFFSET");
        if (offsetString == null) {
            logger.warning("Field " + this.getAttribute("name") + " does not have attribute offset attribute -> offset = -1");
        } else {
            try {
                offset = Integer.parseInt(offsetString) - 1;
            }
            catch (Exception e) {
                logger.warning("Could not parse a number from '" + offsetString + " -> offset = -1");
            }
        }
        return offset;
    }

    @Override
    public String getDocumentation() {
        String documentation = this.fieldMeta != null && this.fieldMeta.getDocumentation() != null ? this.fieldMeta.getDocumentation() : this.getAttribute("TEXT");
        return documentation;
    }

    public String getNativeType() {
        if (this.nativeType == null) {
            this.nativeType = this.fieldMeta != null && this.fieldMeta.getInternalDataType() != null ? this.fieldMeta.getInternalDataType() : this.getAttribute("type");
        }
        return this.nativeType;
    }

    public String getDecimals() {
        String decimals = null;
        if (this.fieldMeta != null && this.fieldMeta.getDecimals() != null) {
            decimals = this.fieldMeta.getDecimals().equals("0") ? this.fieldMeta.getDecimals() : this.fieldMeta.getDecimals().replaceAll("^0*", "");
        }
        return decimals;
    }

    public boolean hasSign() {
        return this.fieldMeta.getDecimals() != null;
    }

    public String getSign() {
        return this.fieldMeta.getSign();
    }

    public boolean hasInternalLength() {
        return !this.getNativeType().startsWith("CHAR");
    }

    public int getInternalLength() {
        int length = this.fieldMeta != null && this.fieldMeta.getInternalLength() != -1 ? this.fieldMeta.getInternalLength() : Integer.parseInt(this.getAttribute("length"));
        return length;
    }

    public int getExternalLength() {
        int length = this.fieldMeta != null && this.fieldMeta.getExternalLength() != -1 ? this.fieldMeta.getExternalLength() : Integer.parseInt(this.getAttribute("length"));
        return length;
    }

    public HashMap getTaggedValues() {
        String decimals;
        HashMap<String, String> taggedValues = new HashMap<String, String>();
        taggedValues.put("nativeType", this.nativeType);
        taggedValues.put("offset", String.valueOf(this.getOffset()));
        taggedValues.put("externalLength", String.valueOf(this.getExternalLength()));
        if (this.hasInternalLength()) {
            taggedValues.put("internalLength", String.valueOf(this.getInternalLength()));
        }
        if ((decimals = this.getDecimals()) != null) {
            if (decimals.length() > 0) {
                taggedValues.put("decimals", decimals);
            }
            if (this.hasSign()) {
                taggedValues.put("sign", this.getSign());
            }
        }
        return taggedValues;
    }

    private void setAttribute(String name, String value) {
        if (name.equalsIgnoreCase("byte_first") || name.equalsIgnoreCase("character_first")) {
            this.attributes.put("OFFSET", value);
        } else {
            this.attributes.put(name.toUpperCase(), value);
        }
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Field " + this.getAttribute("name"));
        sb.append(" (");
        for (Object key : this.attributes.keySet()) {
            Object value = this.attributes.get(key);
            if (((String)key).compareToIgnoreCase("text") == 0) {
                sb.append(key).append("='").append(value).append("', ");
                continue;
            }
            sb.append(key).append("=").append(value).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(")");
        return sb.toString();
    }
}

