/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document;

import ch.e2e.builder.compiler.document.IncludesFile;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.dom.DomUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DependsFile {
    private HashMap<String, IncludesFile> includesFiles = new HashMap();
    private ArrayList<String> mountedDocuments = new ArrayList();
    private boolean dependingOnBaseZip = false;

    public DependsFile(Element dependencies) {
        this.readDependencies(dependencies);
    }

    public void addIncludesFile(UmlDocument umlDocument) {
        IncludesFile includesFile = this.includesFiles.get(umlDocument.getUniqueId());
        if (includesFile == null) {
            this.addFile(umlDocument);
        }
    }

    public void addMountedDocument(UmlDocument umlDocument) {
        if (!this.includesFiles.containsKey(umlDocument.getUniqueId()) && !this.mountedDocuments.contains(umlDocument.getUniqueId())) {
            this.mountedDocuments.add(umlDocument.getUniqueId());
        }
    }

    public ArrayList<String> getMountedDocuments() {
        return this.mountedDocuments;
    }

    public IncludesFile getIncludesFile(UmlDocument umlDocument) {
        IncludesFile includesFile = this.includesFiles.get(umlDocument.getUniqueId());
        if (includesFile == null) {
            includesFile = this.addFile(umlDocument);
        }
        return includesFile;
    }

    public HashMap<String, IncludesFile> getIncludesFiles() {
        return this.includesFiles;
    }

    public void clear() {
        for (IncludesFile includesFile : this.includesFiles.values()) {
            includesFile.clear();
        }
        this.includesFiles.clear();
    }

    public void serialize(Document ownerDocument) {
        Element dependencies = ownerDocument.createElement("dependencies");
        dependencies.setAttribute("dependingOnBaseZip", String.valueOf(this.dependingOnBaseZip));
        for (IncludesFile includesFile : this.includesFiles.values()) {
            Element fileElement = ownerDocument.createElement("includesfile");
            fileElement.setAttribute("umlfileid", includesFile.getUmlFileID());
            fileElement.setAttribute("filename", includesFile.getFilename());
            for (String element : includesFile.getXmiElementIDs()) {
                Element xmlElement = ownerDocument.createElement("xmlelement");
                xmlElement.setAttribute("id", element);
                fileElement.appendChild(xmlElement);
            }
            dependencies.appendChild(fileElement);
        }
        for (String mountId : this.mountedDocuments) {
            Element mountElement = ownerDocument.createElement("mountedFile");
            mountElement.setAttribute("id", mountId);
            dependencies.appendChild(mountElement);
        }
        ownerDocument.getDocumentElement().appendChild(dependencies);
    }

    public boolean isDependingOnBaseZip() {
        return this.dependingOnBaseZip;
    }

    public void setDependingOnBaseZip(boolean dependingOnBaseZip) {
        this.dependingOnBaseZip = dependingOnBaseZip;
    }

    private void readDependencies(Element dependencies) {
        if (dependencies != null) {
            int i;
            this.dependingOnBaseZip = DomUtilities.getBoolean((Element)dependencies, (String)"dependingOnBaseZip", (boolean)true);
            NodeList files = dependencies.getElementsByTagName("includesfile");
            int length = files.getLength();
            for (i = 0; i < length; ++i) {
                IncludesFile includesFile = new IncludesFile((Element)files.item(i));
                this.includesFiles.put(includesFile.getUmlFileID(), includesFile);
            }
            files = dependencies.getElementsByTagName("mountedFile");
            length = files.getLength();
            for (i = 0; i < length; ++i) {
                this.mountedDocuments.add(((Element)files.item(i)).getAttribute("id"));
            }
        }
    }

    private IncludesFile addFile(UmlDocument umlDocument) {
        IncludesFile includesFile = new IncludesFile(umlDocument);
        this.includesFiles.put(umlDocument.getUniqueId(), includesFile);
        return includesFile;
    }
}

