/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.modules.Module;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ModulesTabfile
extends XmlTabfile {
    private Module module;
    private Set<Module> libraries = new LinkedHashSet<Module>();
    private boolean library = false;

    public ModulesTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
        this.setTabfileDocument(DomUtilities.newDocument((String)"modules"));
    }

    public void setCurrentModule(String name, String fileName, String version) {
        this.module = new Module(name, fileName, version);
    }

    @Override
    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
        super.doMergePostProcess(substitutions, library);
        this.module.setLibrary(library);
        this.library = library;
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element replaced = (Element)this.doReplace(table, configurationElement, compilableObject);
        Iterator i = DomUtilities.elementIterator((NodeList)replaced.getElementsByTagName("library"));
        while (i.hasNext()) {
            this.libraries.add(new Module((Element)i.next()));
        }
        return true;
    }

    @Override
    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        this.prepareDocument();
        super.beforeSerialize(zipOut, fileName, library);
    }

    void prepareDocument() {
        this.setTabfileDocument(null);
        Document tabfile = this.getDocument();
        tabfile.getDocumentElement().removeAttribute("xmlns:xmi");
        this.module.buildDom(tabfile.getDocumentElement(), this.library);
        for (Module m : this.libraries) {
            m.buildDom(tabfile.getDocumentElement(), this.library);
        }
    }
}

