/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public abstract class BatchFile {
    private static final String START_SCRIPT_NAME_WIN = "start.bat";
    private static final String KILL_SCRIPT_NAME_WIN = "kill.bat";
    private static final String START_SCRIPT_NAME_LINUX = "start.sh";
    private static final String KILL_SCRIPT_NAME_LINUX = "kill.sh";
    private static final String START_SCRIPT_NAME = CompilerConstants.isWindows() ? "start.bat" : "start.sh";
    private static final String KILL_SCRIPT_NAME = CompilerConstants.isWindows() ? "kill.bat" : "kill.sh";
    private File instanceHome;
    private File batchFile;

    protected BatchFile(File instanceHome) {
        this.instanceHome = instanceHome;
        File binariesFolder = new File(instanceHome, "bin");
        this.batchFile = new File(binariesFolder, this.getFilename());
    }

    public void print() throws FileNotFoundException {
        if (CompilerConstants.isWindows()) {
            this.printWin32();
        } else {
            this.printLinux();
        }
    }

    public void printWin32() throws FileNotFoundException {
        File javaHome = new File(System.getProperty("java.home"));
        File javaBin = new File(javaHome, "bin");
        File[] binFolders = FileUtilities.getAllDirectories((File)javaBin);
        File bridgeHome = new File(System.getProperty("ch.e2e.builder.home"), CompilerConstants.BRIDGE_RUNTIME_BINARIES_FOLDER);
        try {
            PrintWriter writer = new PrintWriter(this.batchFile, "CP850");
            writer.println("@echo off\n\nsetlocal\n\nrem set environment\n");
            writer.println("set BRIDGESERVER_BIN=" + bridgeHome.getAbsolutePath());
            writer.println("set INSTANCES_HOME=" + this.instanceHome.getParentFile().getAbsolutePath());
            writer.println("set INSTANCE_HOME=" + this.instanceHome.getAbsolutePath());
            writer.println("set CONSOLE_HOME=" + bridgeHome.getAbsolutePath());
            StringBuilder javaPath = new StringBuilder(javaBin.getAbsolutePath());
            for (File binFolder : binFolders) {
                javaPath.append(";").append(binFolder.getAbsolutePath());
            }
            writer.println("set PATH=%PATH%;" + javaPath + "\n");
            writer.println("cd /D \"%INSTANCE_HOME%\"");
            writer.println("rem debug");
            writer.println("echo ========================================================================");
            writer.println("cd\necho.\necho PATH             = %PATH%\necho.");
            writer.println("echo BRIDGESERVER_BIN = %BRIDGESERVER_BIN%");
            writer.println("echo INSTANCES_HOME   = %INSTANCES_HOME%");
            writer.println("echo INSTANCE_HOME    = %INSTANCE_HOME%");
            writer.println("echo ========================================================================\n");
            writer.println("rem " + this.getFunction() + " server");
            if (this.isBridgeCommand().booleanValue()) {
                writer.println("\"%BRIDGESERVER_BIN%\\" + CompilerConstants.BRIDGE_RUNTIME_EXECUTABLE + "\" --instance \"%INSTANCE_HOME%\" --dirs.binary \"%BRIDGESERVER_BIN%\" --dirs.data \"%INSTANCES_HOME%\" --dirs.resource \"%INSTANCES_HOME%\\resource\" --logging.config.file \"%INSTANCE_HOME%\\logger.json\"");
            } else {
                writer.println(this.getCommand());
            }
            writer.println("endlocal");
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException e) {
            if (this.batchFile.exists() && e.getMessage().contains("access")) {
                System.err.println(this.batchFile.getAbsolutePath() + ": " + e.getMessage());
            }
            throw e;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void printLinux() throws FileNotFoundException {
        File javaHome = new File(System.getProperty("java.home"));
        File bridgeHome = new File(System.getProperty("ch.e2e.builder.home"), CompilerConstants.BRIDGE_RUNTIME_BINARIES_FOLDER);
        try {
            PrintWriter writer = new PrintWriter(this.batchFile, "UTF-8");
            writer.println("#!/bin/sh");
            writer.println("");
            writer.println("# set environment");
            writer.println("BRIDGESERVER_BIN=\"" + bridgeHome.getAbsolutePath() + "\"");
            writer.println("export BRIDGESERVER_BIN");
            writer.println("INSTANCES_HOME=\"" + this.instanceHome.getParentFile().getAbsolutePath().replace("$", "\\$") + "\"");
            writer.println("export INSTANCES_HOME");
            writer.println("INSTANCE_HOME=\"" + this.instanceHome.getAbsolutePath().replace("$", "\\$") + "\"");
            writer.println("export INSTANCE_HOME");
            writer.println("\n");
            StringBuilder javaPaths = new StringBuilder(javaHome.getAbsolutePath() + "/lib/amd64/server");
            writer.println("# set LD_LIBRARY_PATH environment");
            writer.println("LD_LIBRARY_PATH=\"" + javaPaths + ":$BRIDGESERVER_BIN:$LD_LIBRARY_PATH\"");
            writer.println("export LD_LIBRARY_PATH");
            writer.println("");
            writer.println("# change dir");
            writer.println("cd \"$INSTANCE_HOME\"");
            writer.println("# debug");
            writer.println("echo ========================================================================");
            writer.println("echo \"`pwd`\"");
            writer.println("echo \"LD_LIBRARY_PATH  = $LD_LIBRARY_PATH\"");
            writer.println("echo \"\"");
            writer.println("echo BRIDGESERVER_BIN = $BRIDGESERVER_BIN");
            writer.println("echo INSTANCES_HOME   = $INSTANCES_HOME");
            writer.println("echo INSTANCE_HOME    = $INSTANCE_HOME");
            writer.println("echo ========================================================================\n");
            writer.println("# " + this.getFunction() + " server");
            if (this.isBridgeCommand().booleanValue()) {
                writer.println("\"$BRIDGESERVER_BIN/" + CompilerConstants.BRIDGE_RUNTIME_EXECUTABLE + "\" " + this.getCommand() + "repository \"$INSTANCE_HOME/repository/tabfiles\"\n");
            } else {
                writer.println(this.getCommand());
            }
            writer.flush();
            writer.close();
            if (!this.batchFile.setExecutable(true, false)) {
                throw new BuildException("Exception: Unable to set \"" + this.batchFile.getAbsolutePath() + "\" executable.");
            }
        }
        catch (FileNotFoundException e) {
            if (this.batchFile.exists() && e.getMessage().contains("access")) {
                System.err.println(this.batchFile.getAbsolutePath() + ": " + e.getMessage());
            }
            throw e;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public File getFile() {
        return this.batchFile;
    }

    protected abstract String getFilename();

    protected abstract String getFunction();

    protected abstract String getCommand();

    protected abstract Boolean isBridgeCommand();

    public static class Kill
    extends BatchFile {
        protected Kill(File instanceHome) {
            super(instanceHome);
        }

        @Override
        protected String getFilename() {
            return KILL_SCRIPT_NAME;
        }

        @Override
        protected String getFunction() {
            return "kill";
        }

        @Override
        protected String getCommand() {
            if (CompilerConstants.isWindows()) {
                return "if exist \"%INSTANCE_HOME%\\server.pid\" (\n\tpushd \"%INSTANCE_HOME%\"\n\n\tfor /F %%p in ( server.pid ) do call taskkill /F /PID %%p 1>nul 2>nul \n\n\tdel \"%INSTANCE_HOME%\\server.pid\"\n\tpopd\n)else (\n\techo Found no process id file \"%INSTANCE_HOME%\\server.pid\".\n\tset status=4\n)\n\necho exit status %status%\n\nexit /b %status%\n";
            }
            return "if [ -f server.pid ] ; then\n\tProcessID=`cat server.pid`\n\n\tkill ${ProcessID}\n\techo Killed process ${ProcessID}\n\trm server.pid\n\texit 0\nelse\n\techo Missing file server.pid\n\texit 2\nfi";
        }

        @Override
        protected Boolean isBridgeCommand() {
            return false;
        }
    }

    public static class Start
    extends BatchFile {
        protected Start(File instanceHome) {
            super(instanceHome);
        }

        @Override
        protected String getFilename() {
            return START_SCRIPT_NAME;
        }

        @Override
        protected String getFunction() {
            return "start";
        }

        @Override
        protected String getCommand() {
            return "";
        }

        @Override
        protected Boolean isBridgeCommand() {
            return true;
        }
    }
}

