/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.rest;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.utils.ClientUtils;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public abstract class RestTask
extends CacheAbleTask {
    public RestTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        this.executeRestOperation(dependencyLevel);
    }

    protected String getMethod() {
        return "POST";
    }

    protected void executeRestOperation(int dependencyLevel) {
        Client client = ClientUtils.getClient();
        try (Response response = client.target(this.getBaseUrl()).path(this.getActionPath()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).build(this.getMethod(), this.getEntity()).invoke();){
            this.handleResponse(response);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    protected abstract String getBaseUrl();

    protected abstract String getActionPath();

    protected abstract Entity<?> getEntity();

    protected abstract void handleResponse(Response var1) throws Exception;

    protected void handleError(Exception e) {
        this.getErrorHandler().error((Throwable)e);
    }
}

