/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.usage;

import ch.e2e.builder.compiler.build.tasks.XSLTTask;
import ch.e2e.builder.compiler.build.tasks.source.IDLSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import java.util.HashSet;
import java.util.Set;

public class LibraryClassUsagesTask
extends XSLTTask {
    public static Boolean select(String id) {
        return id.endsWith(".library.classes.usages.xml");
    }

    public LibraryClassUsagesTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".library.classes.usages.xml";
    }

    @Override
    protected String getTransformerId() {
        return "model.usage.library.class.usages";
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getDestinationFilePathWithoutExtension() + ".library.lrep.idl.xml");
        return result;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        String sourceId = this.getDestinationFilePathWithoutExtension() + ".library.lrep.idl.xml";
        result.add(sourceId);
        IDLImportSource idlImportSource = ((IDLSource)this.getSourceManager().getSource(sourceId)).getIDLImportSource();
        for (IDLImportSource imported : idlImportSource.getImportedElements()) {
            result.add("libs/" + imported.getName() + ".library.classes.usages.xml");
        }
        return result;
    }
}

