/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular.typescript.libs;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.libraries.JsonIdlImportSource;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.typescript.documents.TypescriptImport;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.typescript.documents.TypescriptImports;
import ch.e2e.builder.compiler.build.tasks.source.IDLSource;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.json.idl.Idl;
import ch.e2e.builder.compiler.document.json.library.LibraryContent;
import ch.e2e.builder.compiler.document.json.library.LibraryDescriptor;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class LibraryTypescriptImportsTask
extends CacheAbleTask
implements XSLTTransformSource {
    private final String libraryName = this.getDestinationFileNameWithoutExtension();
    private LibraryDescriptor libraryDescriptor;

    public static Boolean select(String id) {
        return id.endsWith(".library.ts.imports.xml");
    }

    public LibraryTypescriptImportsTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".library.ts.imports.xml";
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> sourceSet = super.getBeforeSourceSet();
        sourceSet.add(Files.libs_LIBRARY__library_descriptor_xml(this.libraryName));
        return sourceSet;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> sourceSet = super.getSourceSet();
        LibraryDescriptor descriptor = this.getDescriptor();
        if (descriptor.getContent().getAngular() != null && descriptor.getContent().getImplementation().equals((Object)LibraryContent.Implementation.json)) {
            sourceSet.add(Files.libs_LIBRARY__LIBRARY_library_idl_json(this.libraryName));
        }
        return sourceSet;
    }

    private LibraryDescriptor getDescriptor() {
        if (this.libraryDescriptor == null) {
            JsonDocumentSource descriptorSource = (JsonDocumentSource)this.getSourceManager().getSource(Files.libs_LIBRARY__library_descriptor_xml(this.libraryName));
            this.libraryDescriptor = descriptorSource.getJsonDocument(LibraryDescriptor.class);
        }
        return this.libraryDescriptor;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            TypescriptImports typescriptImports = new TypescriptImports();
            LibraryDescriptor descriptor = this.getDescriptor();
            typescriptImports.setName(descriptor.getName());
            if (descriptor.getContent().getAngular().getPackage() != null && descriptor.getContent().getImplementation().equals((Object)LibraryContent.Implementation.json)) {
                IDLSource idlSource = (IDLSource)this.getSourceManager().getSource(Files.libs_LIBRARY__LIBRARY_library_idl_json(this.libraryName));
                JsonIdlImportSource idlImportSource = (JsonIdlImportSource)idlSource.getIDLImportSource();
                Idl idl = idlImportSource.getOriginalIdl();
                idl.getPackages().forEach(idlPackage -> idlPackage.getClasses().forEach(idlClass -> {
                    TypescriptImport typescriptImport = new TypescriptImport();
                    typescriptImport.setName(idlClass.getName());
                    typescriptImport.setFrom(descriptor.getContent().getAngular().getPackage().getName());
                    if (idlClass.getAppliedStereotypes() != null) {
                        idlClass.getAppliedStereotypes().stream().filter(xumlAppliedStereotype -> xumlAppliedStereotype.getStereotype().equals("TypescriptClass")).forEach(xumlAppliedStereotype -> {
                            typescriptImport.setName(xumlAppliedStereotype.getSimpleTagValue("importName", typescriptImport.getName()));
                            typescriptImport.setFrom(xumlAppliedStereotype.getSimpleTagValue("importFrom", typescriptImport.getFrom()));
                        });
                    }
                    typescriptImports.getMap().put(idlClass.getId(), typescriptImport);
                }));
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TypescriptImports.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            DOMResult result = new DOMResult();
            jaxbMarshaller.marshal((Object)typescriptImports, (Result)result);
            DomUtilities.serialize((File)this.getDestinationFile(), (Node)result.getNode(), (boolean)true);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

