/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.error.TaskFatalError;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlLibraryUsage;
import ch.e2e.builder.compiler.utils.EnvUtils;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class DownloadLibraryTask
extends CacheAbleTask {
    private static final String XUML_LIBRARY_REPOSITORY_PROTOCOL = EnvUtils.get("XUML_LIBRARY_REPOSITORY_SERVICE_HTTP_PROTOCOL", "http");
    private static final String XUML_LIBRARY_REPOSITORY_HOSTNAME = EnvUtils.get("XUML_LIBRARY_REPOSITORY_SERVICE_HOSTNAME", "xuml-library-repository-service");
    private static final String XUML_LIBRARY_REPOSITORY_PORT = EnvUtils.get("XUML_LIBRARY_REPOSITORY_SERVICE_PORT", "3007");
    private static final String XUML_LIBRARY_REPOSITORY_BASE_URL = XUML_LIBRARY_REPOSITORY_PROTOCOL + "://" + XUML_LIBRARY_REPOSITORY_HOSTNAME + ":" + XUML_LIBRARY_REPOSITORY_PORT + "/repo";

    public static Boolean select(String id) {
        return id.endsWith(".library.xlib");
    }

    public DownloadLibraryTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourceId());
        return result;
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".library.xlib";
    }

    private String getSourceId() {
        return ch.e2e.builder.compiler.build.tasks.constants.Files.libs__LIBRARY_library_xml(this.getDestinationFileNameWithoutExtension());
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            JsonDocumentSource source = (JsonDocumentSource)this.getSource(this.getSourceId());
            if (source == null) {
                return;
            }
            XumlLibraryUsage libraryUsage = source.getJsonDocument(XumlLibraryUsage.class);
            Client client = ClientBuilder.newClient();
            String userId = "INTERNAL_STORAGE_REQUEST";
            WebTarget webTarget = client.target(XUML_LIBRARY_REPOSITORY_BASE_URL).path(userId).path(libraryUsage.getRepository()).path(libraryUsage.getName()).path(libraryUsage.getVersion());
            Invocation.Builder invocationBuilder = webTarget.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE});
            Response response = invocationBuilder.get();
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("name", libraryUsage.getName());
                parameters.put("version", libraryUsage.getVersion());
                parameters.put("repository", libraryUsage.getRepository());
                this.getErrorHandler().fatalError((BuilderFatalError)new TaskFatalError("FLIB0001", parameters));
                return;
            }
            InputStream inputStream = (InputStream)response.getEntity();
            this.getDestinationFile().getParentFile().mkdirs();
            Files.copy(inputStream, this.getDestinationFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public boolean isUpToDate() {
        return !this.getErrorHandler().hasErrors() && super.isUpToDate();
    }
}

