/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CompileConfigurationTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.types.Repository;
import ch.e2e.builder.compiler.build.types.WrapperJarfileMerger;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.Library;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.builder.compiler.descriptor.RepositoryArchiveResource;
import ch.e2e.builder.compiler.descriptor.RepositoryResource;
import ch.e2e.builder.compiler.descriptor.ResourceList;
import ch.e2e.builder.compiler.error.DefaultCompilerError;
import ch.e2e.builder.compiler.error.RepositoryError;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RepositoryTask
extends CompileConfigurationTask {
    private Map<String, File> destFiles = new HashMap<String, File>();

    public void setDestFile(String compilableObjectName, File file) {
        this.destFiles.put(compilableObjectName, file);
    }

    public RepositoryTask() {
        super(new CompileControl[0]);
    }

    @Override
    protected void propagateErrors() {
        super.propagateErrors();
        for (CompilableObject compilableObject : this.getCompilableObjects()) {
            compilableObject.getErrorHandler().serialize(true);
        }
    }

    protected void copyZipEntries(ZipFile input, ZipOutputStream out, List<String> existingEntries) throws IOException {
        Enumeration<? extends ZipEntry> entries = input.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (existingEntries.contains(entry.getName())) continue;
            existingEntries.add(entry.getName());
            out.putNextEntry(entry);
            FileUtilities.copy((InputStream)input.getInputStream(entry), (OutputStream)out, (boolean)false);
            out.closeEntry();
        }
    }

    @Override
    public boolean isUpToDate() {
        for (CompilableObject compilableObject : this.getCompilableObjects()) {
            if (this.getRepository(compilableObject).isUpToDate(compilableObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected AbstractErrorHandler executeDependsOnTasks(int dependencyLevel) {
        for (CompilableObject compilableObject : this.getCompilableObjects()) {
            compilableObject.getErrorHandler().clear(true, true);
        }
        return super.executeDependsOnTasks(dependencyLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTask(int dependencyLevel) throws BuildException {
        for (CompilableObject compilableObject : this.getCompilableObjects()) {
            Repository repository = this.getRepository(compilableObject);
            for (Deployment deployment : compilableObject.getDeployments()) {
                File jarfile = this.destFiles.get(compilableObject.getName());
                if (jarfile == null) {
                    jarfile = repository.getTargetFile(deployment);
                }
                if (jarfile.exists()) {
                    jarfile.delete();
                } else {
                    jarfile.getParentFile().mkdirs();
                }
                ZipOutputStream out = null;
                try {
                    ArrayList<String> existingEntries = new ArrayList<String>();
                    out = new ZipOutputStream(new FileOutputStream(jarfile));
                    out.putNextEntry(new ZipEntry("deploy.xml"));
                    existingEntries.add("deploy.xml");
                    DomUtilities.serialize((OutputStream)out, (Document)repository.getDeployDocument(deployment.getName()), (boolean)false, (boolean)false);
                    out.putNextEntry(new ZipEntry("templates/"));
                    existingEntries.add("templates/");
                    File tabfileContainer = repository.getTabfileContainer(deployment.getName());
                    if (tabfileContainer.exists()) {
                        ZipFile tabZipfile = new ZipFile(tabfileContainer);
                        try {
                            this.copyZipEntries(tabZipfile, out, existingEntries);
                        }
                        finally {
                            try {
                                tabZipfile.close();
                            }
                            catch (Exception e) {
                                Logging.logger.finest("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                            }
                        }
                    }
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("absolute path", tabfileContainer.getAbsolutePath());
                    DefaultCompilerError error = new DefaultCompilerError("error.file.not.found", parameters);
                    compilableObject.getErrorHandler().error(error);
                    this.addJavaAndResources(compilableObject, out, deployment, existingEntries);
                    if (compilableObject instanceof Library) {
                        this.addLibraryInterface(out, existingEntries, compilableObject);
                        File asynchronousTrace = new File(compilableObject.getUmlDocument().getDocumentWorkingFolder(), "asynchronous.trace.template");
                        if (!asynchronousTrace.exists()) continue;
                        out.putNextEntry(new ZipEntry("asynchronous.trace"));
                        existingEntries.add("asynchronous.trace");
                        FileUtilities.copy((InputStream)new FileInputStream(asynchronousTrace), (OutputStream)out, (boolean)false);
                        continue;
                    }
                    Document asynchronousTraceInfo = repository.getAsynchronousTraceDocument(deployment.getName());
                    if (asynchronousTraceInfo == null) continue;
                    out.putNextEntry(new ZipEntry("asynchronous.trace"));
                    existingEntries.add("asynchronous.trace");
                    DomUtilities.serialize((OutputStream)out, (Document)asynchronousTraceInfo, (boolean)false, (boolean)false);
                }
                catch (Exception e) {
                    Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    Logging.logger.throwing(this.getClass().getName(), "executeTask", e);
                    this.getErrorHandler().error((Throwable)e);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        Logging.logger.finest("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    }
                    if (this.getErrorHandler().getErrorCount() > 0) {
                        jarfile.delete();
                    }
                    compilableObject.getErrorHandler().serialize(false);
                }
            }
        }
    }

    protected void addJavaAndResources(CompilableObject composite, ZipOutputStream out, Deployment deployment, ArrayList<String> existingEntries) throws IOException {
        WrapperJarfileMerger wrapperMerger = new WrapperJarfileMerger();
        this.addArchives(composite, wrapperMerger, out, existingEntries);
        this.addLibraries(composite, wrapperMerger, out, existingEntries);
        wrapperMerger.addMergedWrapperJarfile(out, existingEntries);
        wrapperMerger.addAddOnJarfile(out, existingEntries);
        this.addResources(deployment, out, existingEntries);
    }

    protected void addArchives(CompilableObject configuration, WrapperJarfileMerger wrapperMerger, ZipOutputStream out, ArrayList<String> existingEntries) throws IOException {
        if (configuration.containsJavaService()) {
            this.addJarfiles(configuration, out, existingEntries, wrapperMerger);
            this.addXarfiles(configuration, out, existingEntries);
            this.addXSLTScripts(configuration, out, existingEntries);
        }
    }

    protected void addLibraries(CompilableObject configuration, WrapperJarfileMerger wrapperMerger, ZipOutputStream out, ArrayList<String> existingEntries) throws IOException {
        for (LibraryService library : configuration.getLibraries()) {
            ZipFile repository = new ZipFile(library.getRepository());
            Throwable throwable = null;
            try {
                Enumeration<? extends ZipEntry> entries = repository.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.getName().equals("java/lib/wrapper.jar")) {
                        File tempWrapper = File.createTempFile("wrapper.jar", ".jar");
                        tempWrapper.deleteOnExit();
                        FileUtilities.copy((InputStream)repository.getInputStream(entry), (OutputStream)new FileOutputStream(tempWrapper));
                        wrapperMerger.addWrapperJar(tempWrapper);
                        continue;
                    }
                    if (entry.getName().equals("java/lib/addon.jar")) {
                        File tempAddOn = File.createTempFile("addon.jar", ".jar");
                        tempAddOn.deleteOnExit();
                        FileUtilities.copy((InputStream)repository.getInputStream(entry), (OutputStream)new FileOutputStream(tempAddOn));
                        wrapperMerger.addAddOnJar(tempAddOn);
                        File addOnPath = new File(System.getProperty("ch.e2e.builder.system.library.path"), "addon.jar");
                        wrapperMerger.addAddOnJar(addOnPath);
                        continue;
                    }
                    if (!entry.getName().startsWith("java/lib/") && !entry.getName().startsWith("java/resources/") && !entry.getName().startsWith("htdocs/") && !entry.getName().startsWith("xslt/") && !entry.getName().startsWith("resources")) continue;
                    this.addEntry(entry, repository, out, existingEntries);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (repository == null) continue;
                if (throwable != null) {
                    try {
                        repository.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                repository.close();
            }
        }
    }

    private void addJarfiles(CompilableObject configuration, ZipOutputStream out, ArrayList<String> existingEntries, WrapperJarfileMerger wrapperMerger) throws IOException {
        String[] jarfiles;
        File jarfileFolder = this.getUmlDocument().getSettings().getJarFolder();
        for (String jarfile : jarfiles = configuration.getJarfilesToDeploy()) {
            this.addFile(jarfile, jarfileFolder, "java/lib/", out, existingEntries, "error.jarfile.to.deploy.not.found");
        }
        File addOnPath = new File(System.getProperty("ch.e2e.builder.system.library.path"), "addon.jar");
        wrapperMerger.addAddOnJar(addOnPath);
        this.addWrapperJar(configuration, wrapperMerger);
    }

    protected void addWrapperJar(CompilableObject configuration, WrapperJarfileMerger wrapperMerger) throws IOException {
        File workingFolder = configuration.getUmlDocument().getDocumentWorkingFolder();
        File wrapperLibPath = new File(workingFolder, "wrapper/lib");
        File wrapperJar = new File(wrapperLibPath, "wrapper.jar");
        if (wrapperJar.exists()) {
            wrapperMerger.addWrapperJar(wrapperJar);
        }
    }

    private void addXarfiles(CompilableObject configuration, ZipOutputStream out, ArrayList<String> existingEntries) throws IOException {
        String[] xarfiles = configuration.getXarfilesToDeploy();
        File xsltFolder = this.getUmlDocument().getSettings().getXSLTFolder();
        for (String xarfile : xarfiles) {
            this.addFile(xarfile, xsltFolder, "xslt/lib/", out, existingEntries, "error.xslt.archive.to.deploy.not.found");
        }
    }

    protected void addResources(Deployment deployment, ZipOutputStream out, ArrayList<String> existingEntries) throws IOException {
        ResourceList resources = deployment.getCompilableObject().getResources();
        resources.sort((o1, o2) -> {
            if (o1 instanceof RepositoryArchiveResource) {
                return -1;
            }
            if (o2 instanceof RepositoryArchiveResource) {
                return 1;
            }
            return 0;
        });
        for (RepositoryResource resource : resources) {
            resource.applyToTargetFiles(stringInputStreamEntry -> {
                try {
                    ZipEntry entry = new ZipEntry((String)stringInputStreamEntry.getKey());
                    this.addFile((InputStream)stringInputStreamEntry.getValue(), entry, out, existingEntries, "error.resource.to.deploy.not.found");
                }
                catch (IOException e) {
                    this.getErrorHandler().error((Throwable)e);
                }
            }, this.getErrorHandler());
        }
    }

    private void addXSLTScripts(CompilableObject configuration, ZipOutputStream out, ArrayList<String> existingEntries) throws IOException {
        String[] xsltScripts = configuration.getXSLTScripts();
        File folder = this.getUmlDocument().getSettings().getXSLTFolder();
        for (String xsltScript : xsltScripts) {
            this.addFile(xsltScript, folder, "xslt/src/", out, existingEntries, "error.xslt.script.to.deploy.not.found");
        }
    }

    protected void addFile(String filename, File srcFolder, String zipFolder, ZipOutputStream out, ArrayList<String> existingEntries, String errorCode) throws IOException {
        ZipEntry entry = new ZipEntry(zipFolder + filename);
        File file = new File(srcFolder, filename);
        this.addFile(file, entry, out, existingEntries, errorCode);
    }

    private void addFile(InputStream file, ZipEntry entry, ZipOutputStream out, ArrayList<String> existingEntries, String errorCode) throws IOException {
        if (!existingEntries.contains(entry.getName())) {
            if (file != null) {
                out.putNextEntry(entry);
                FileUtilities.copy((InputStream)file, (OutputStream)out, (boolean)false);
                existingEntries.add(entry.getName());
                out.closeEntry();
            } else {
                HashMap<String, String> parameter = new HashMap<String, String>();
                parameter.put("absolute path", entry.getName());
                RepositoryError error = new RepositoryError(errorCode, parameter);
                this.getErrorHandler().error((AbstractBuilderError)error);
            }
        }
    }

    private void addFile(File file, ZipEntry entry, ZipOutputStream out, ArrayList<String> existingEntries, String errorCode) throws IOException {
        if (!existingEntries.contains(entry.getName())) {
            if (file.exists()) {
                out.putNextEntry(entry);
                FileUtilities.copy((InputStream)new FileInputStream(file), (OutputStream)out, (boolean)false);
                existingEntries.add(entry.getName());
                out.closeEntry();
            } else {
                HashMap<String, String> parameter = new HashMap<String, String>();
                parameter.put("absolute path", file.getAbsolutePath());
                RepositoryError error = new RepositoryError(errorCode, parameter);
                this.getErrorHandler().error((AbstractBuilderError)error);
            }
        }
    }

    private void addEntry(ZipEntry entry, ZipFile from, ZipOutputStream out, ArrayList<String> existingEntries) throws IOException {
        if (!existingEntries.contains(entry.getName()) && !entry.isDirectory()) {
            out.putNextEntry(new ZipEntry(entry.getName()));
            FileUtilities.copy((InputStream)from.getInputStream(entry), (OutputStream)out, (boolean)false);
            out.closeEntry();
            existingEntries.add(entry.getName());
        }
    }

    @Override
    protected String getCompilerId() {
        return "repository.create";
    }

    @Override
    public String toString() {
        return "repository";
    }

    private void addLibraryInterface(ZipOutputStream out, ArrayList<String> existingEntries, CompilableObject library) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        File interfaceFile = new File(library.getUmlDocument().getDocumentWorkingFolder(), "library.interface");
        out.putNextEntry(new ZipEntry("library.interface"));
        existingEntries.add("library.interface");
        Document libraryInterface = DomUtilities.parse((File)interfaceFile, (boolean)false, (boolean)false, (boolean)false);
        libraryInterface.getDocumentElement().setAttribute("trace", CompilerConstants.getProjectValue("trace.state"));
        if (library.getLibraries().size() > 0) {
            ArrayList<LibraryInfo> importedLibraries = this.getImportedLibraries(library.getLibraries());
            Element importElement = libraryInterface.createElement("Import");
            for (LibraryInfo libraryInfo : importedLibraries) {
                Element libraryElement = libraryInterface.createElement("Library");
                libraryElement.setAttribute("name", libraryInfo.name);
                libraryElement.setAttribute("buildID", libraryInfo.buildID);
                libraryElement.setAttribute("version", libraryInfo.version);
                importElement.appendChild(libraryElement);
            }
            libraryInterface.getDocumentElement().appendChild(importElement);
        }
        DomUtilities.serialize((OutputStream)out, (Document)libraryInterface, (boolean)true, (boolean)false);
        out.closeEntry();
    }

    private ArrayList<LibraryInfo> getImportedLibraries(ArrayList<LibraryService> libraries) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<LibraryInfo> importedLibraries = new ArrayList<LibraryInfo>();
        for (LibraryService library : libraries) {
            Element libraryRoot = library.getLibraryInterface().getDocumentElement();
            LibraryInfo info = new LibraryInfo();
            info.name = libraryRoot.getAttribute("library");
            info.buildID = libraryRoot.getAttribute("buildID");
            info.version = libraryRoot.getAttribute("version");
            importedLibraries.add(info);
        }
        return importedLibraries;
    }

    private class LibraryInfo {
        private String name;
        private String version;
        private String buildID;

        private LibraryInfo() {
        }
    }
}

