/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.process;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.error.BuilderException;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.base.xsltinterface.XSLTAction;
import ch.e2e.builder.compiler.build.BuildErrorException;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.GroupIdService;
import ch.e2e.builder.compiler.build.action.BuildAction;
import ch.e2e.builder.compiler.build.tasks.CompilerTask;
import ch.e2e.builder.compiler.build.tasks.DeployTask;
import ch.e2e.builder.compiler.build.tasks.ExmiWithImportTask;
import ch.e2e.builder.compiler.build.tasks.Xmi2TabTask;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.document.DependsFile;
import ch.e2e.builder.compiler.document.IncludesFile;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.builder.compiler.event.SendErrorEvent;
import ch.e2e.builder.compiler.event.SendInfoEvent;
import ch.e2e.builder.compiler.event.SendStatusEvent;
import ch.e2e.builder.compiler.event.SendWarningEvent;
import ch.e2e.builder.compiler.xsltinterface.XSLTInput;
import ch.e2e.builder.compiler.xsltinterface.XSLTOutput;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.logging.LogManager;
import ch.e2e.logging.PerformanceLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class BuildProcess {
    private static Logger logger = LogManager.getLogger((String)BuildProcess.class.getName());
    private Map<String, String> replaceMap = new HashMap<String, String>();
    protected long startTime;
    private BuildAction buildAction;
    private HashMap<File, Document> tabfileTables = new HashMap();
    private UmlDocument umlDocument;

    protected UmlDocumentFactory getUmlDocumentFactory() {
        return this.getUmlDocument().getUmlDocumentFactory();
    }

    public UmlDocument getUmlDocument() {
        return this.umlDocument;
    }

    public void setUmlDocument(UmlDocument umlDocument) {
        this.umlDocument = umlDocument;
    }

    final void start(CompilerTask task, UmlDocument umlDocument) {
        this.setUmlDocument(umlDocument);
        this.executeTask(task);
    }

    final void start(DeployTask task) {
        this.executeTask(task);
    }

    public CompilableObject getCompilableObject() {
        return null;
    }

    public void saveTabfileTables(Document tables, File tabfileContainer) throws IOException, TransformerException {
        DomUtilities.serialize((File)tabfileContainer, (Document)tables, (boolean)false);
        this.tabfileTables.put(tabfileContainer, tables);
    }

    public Document getTabfileTables(File tabfileContainer) throws SAXException, IOException, ParserConfigurationException {
        Document tables = this.tabfileTables.get(tabfileContainer);
        if (tables == null) {
            tables = DomUtilities.parse((File)tabfileContainer, (boolean)false, (boolean)false);
            this.tabfileTables.put(tabfileContainer, tables);
        }
        return tables;
    }

    public Map<String, String> getReplaceMap() {
        return this.replaceMap;
    }

    public BuildAction getBuildAction() {
        return this.buildAction;
    }

    protected void setBuildAction(BuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public Object getSendEventSource() {
        return this.buildAction == null ? this : this.buildAction;
    }

    public String getBuildSource() {
        return this.buildAction.getBuildSource();
    }

    public String getLogSource() {
        return this.getUmlDocument().getAbsolutePath();
    }

    final void executeTask(DeployTask task) {
        block3: {
            try {
                long start = PerformanceLogger.start((String)task.toString(), (String)this.getLogSource());
                task.execute();
                PerformanceLogger.stop((String)task.toString(), (String)this.getLogSource(), (long)start);
            }
            catch (OutOfMemoryError outOfMemory) {
                XSLTErrorHandler.getInstance().error((Throwable)outOfMemory);
            }
            catch (Throwable error) {
                this.doErrorHandling(error);
                if (error instanceof BuildErrorException) break block3;
                logger.severe("Error during buildprocess: " + error.getMessage());
                logger.throwing(task.getClass().getName(), "executeTask", error);
            }
        }
    }

    final void executeTask(CompilerTask task) {
        block3: {
            try {
                long start = PerformanceLogger.start((String)task.toString(), (String)this.getLogSource());
                task.setUmlDocument(this.getUmlDocument());
                task.execute();
                PerformanceLogger.stop((String)task.toString(), (String)this.getLogSource(), (long)start);
            }
            catch (OutOfMemoryError outOfMemory) {
                XSLTErrorHandler.getInstance().error((Throwable)outOfMemory);
            }
            catch (Throwable error) {
                this.doErrorHandling(error);
                if (error instanceof BuildErrorException) break block3;
                logger.severe("Error during buildprocess: " + error.getMessage());
                logger.throwing(task.getClass().getName(), "executeTask", error);
            }
        }
    }

    final void resetDocumentErrorHandler() {
        UmlDocument[] allDocuments;
        UmlDocumentFactory factory = this.getUmlDocumentFactory();
        for (UmlDocument allDocument : allDocuments = factory.getAllDocuments()) {
            allDocument.getErrorHandler().resetErrorsCleared();
        }
    }

    protected void doBuildStartup(BuildAction buildAction) {
        this.buildAction = buildAction;
        XSLTOutput.setXsltAction((XSLTAction)buildAction);
        EventController.fire((EventObject)((Object)new SendStatusEvent(this, "status.compiling")));
        this.startTime = new Date().getTime();
        XSLTErrorHandler.getInstance().reset();
        XSLTInput.init();
        XSLTOutput.reset();
        if (buildAction != null && buildAction.getUmlDocuments() != null) {
            for (UmlDocument document : buildAction.getUmlDocuments()) {
                if (!document.hasDescriptor()) continue;
                for (Deployment deployment : document.getDescriptor().getAllDeployments()) {
                    deployment.getDeployErrorHandler().clear(true);
                }
            }
        }
        this.sendStartInfoMessage();
    }

    protected abstract void sendStartInfoMessage();

    protected void buildFinished() {
        EventController.fire((EventObject)((Object)new SendStatusEvent(this, "")));
        GroupIdService.saveAndClear();
        long time = (new Date().getTime() - this.startTime) / 1000L;
        String timeStr = String.valueOf(time);
        this.replaceMap.put("build.time", timeStr);
        this.showBuildEndStatus();
    }

    protected void activateGarbageCollector() {
        long start = PerformanceLogger.start((String)"calling garbage collector", (String)this.getLogSource());
        System.gc();
        PerformanceLogger.stop((String)"calling garbage collector", (String)this.getLogSource(), (long)start);
    }

    private void showBuildEndStatus() {
        int errors = XSLTErrorHandler.getInstance().getErrorCount();
        int warnings = XSLTErrorHandler.getInstance().getWarningCount();
        if (this.buildAction != null && this.buildAction.getUmlDocuments() != null) {
            for (UmlDocument umlDocument : this.buildAction.getUmlDocuments()) {
                errors += umlDocument.getErrorCount();
                warnings += umlDocument.getWarningCount();
            }
        }
        this.replaceMap.put("error.count", String.valueOf(errors));
        this.replaceMap.put("warning.count", String.valueOf(warnings));
        Object event = errors > 0 ? (warnings > 0 ? new SendErrorEvent(this.getSendEventSource(), "build.with.errors.and.warnings", this.replaceMap) : new SendErrorEvent(this.getSendEventSource(), "build.with.errors", this.replaceMap)) : (warnings > 0 ? new SendWarningEvent(this.getSendEventSource(), "build.with.warnings", this.replaceMap) : new SendInfoEvent(this.getSendEventSource(), "build.successfull", this.replaceMap));
        EventController.fire((EventObject)event);
    }

    void doErrorHandling(Throwable error) {
        if (!(error instanceof BuildErrorException)) {
            BuilderException exception = null;
            if (XSLTErrorHandler.getInstance().getErrorCount() == 0) {
                if (error instanceof BuildException) {
                    BuildException bEx = (BuildException)error;
                    if (bEx.getCause() != null) {
                        logger.severe("Caught a " + bEx.getCause().getClass().getName() + ": " + bEx.getException().getMessage());
                        bEx.getCause().printStackTrace();
                        logger.throwing(this.getClass().getName(), "doErrorHandling", bEx.getCause());
                        exception = new BuilderException("error.build.exception", bEx.getCause());
                    } else {
                        logger.severe("Caught a " + bEx.getClass().getName() + ": " + bEx.getMessage());
                        logger.throwing(this.getClass().getName(), "doErrorHandling", bEx);
                        bEx.printStackTrace();
                        exception = new BuilderException("error.build.exception", (Throwable)bEx);
                    }
                }
            } else if (error instanceof BuildException) {
                BuildException bEx = (BuildException)error;
                if (bEx.getCause() != null) {
                    logger.severe("Caught a " + bEx.getCause().getClass().getName() + ": " + bEx.getException().getMessage());
                    logger.throwing(this.getClass().getName(), "doErrorHandling", bEx.getCause());
                    bEx.getCause().printStackTrace();
                    exception = new BuilderException("error.build.exception", bEx.getCause());
                } else {
                    logger.severe("Caught a " + bEx.getClass().getName() + ": " + bEx.getMessage());
                    logger.throwing(this.getClass().getName(), "doErrorHandling", bEx);
                    bEx.printStackTrace();
                    exception = new BuilderException("error.build.exception", (Throwable)bEx);
                }
            } else {
                exception = new BuilderException(error);
                EventController.fire((EventObject)((Object)new SendErrorEvent(this.getSendEventSource(), (BuilderError)exception)));
                logger.severe("Caught a " + error.getClass().getName() + ": " + error.getMessage());
                logger.throwing(this.getClass().getName(), "doErrorHandling", error);
                error.printStackTrace();
            }
            if (exception != null) {
                error.printStackTrace();
                XSLTErrorHandler.getInstance().error((AbstractBuilderError)exception);
                EventController.fire((EventObject)((Object)new SendErrorEvent(this.getSendEventSource(), (BuilderError)exception)));
            }
        }
    }

    protected void cleanProcess() {
        this.replaceMap.clear();
        this.tabfileTables.clear();
        this.activateGarbageCollector();
    }

    protected void buildTabfiles(UmlDocument umlDocument, ArrayList<String> xmi2tabBuilt) {
        if (!xmi2tabBuilt.contains(umlDocument.getUniqueId())) {
            xmi2tabBuilt.add(umlDocument.getUniqueId());
            XSLTInput.setCurrentXmiFile(umlDocument);
            CompilerTask[] tasks = new CompilerTask[]{new ExmiWithImportTask(), new Xmi2TabTask()};
            XSLTErrorHandler.getInstance().addErrorHandler((AbstractErrorHandler)umlDocument.getErrorHandler());
            for (CompilerTask task : tasks) {
                this.start(task, umlDocument);
                if (task.getErrorHandler().getErrorCount() > 0) break;
            }
            umlDocument.getErrorHandler().serialize(true);
            XSLTErrorHandler.getInstance().removeErrorHandler((AbstractErrorHandler)umlDocument.getErrorHandler());
            if (umlDocument.getErrorHandler().getErrorCount() == 0) {
                this.buildDependingTabfiles(umlDocument, xmi2tabBuilt);
            }
        }
    }

    private void buildDependingTabfiles(UmlDocument umlDocument, ArrayList<String> xmi2tabBuilt) {
        DependsFile dependsFile = umlDocument.getDocumentInfo().getDependsFile();
        for (IncludesFile includesFile : dependsFile.getIncludesFiles().values()) {
            UmlDocument importedDocument = this.getUmlDocumentFactory().getUmlDocumentById(includesFile.getUmlFileID());
            this.buildTabfiles(importedDocument, xmi2tabBuilt);
        }
    }

    static {
        logger.setLevel(Level.ALL);
    }
}

