/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.message;

import ch.e2e.swing.MessageGroup;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class MessageGroupsPool {
    public static final String MESSAGE_GROUPS_POOL_KEY = "ch.e2e.base.message.MessageGroupsPool.key";
    private static MessageGroupsPool pool;
    private MessageGroup defaultGroup = null;
    private HashMap<Class, Class> messageGroupClasses = new HashMap();
    private HashMap<String, MessageGroup> messageGroups = new HashMap();
    private HashMap<String, HashMap<Class, Class>> moduleClassesMap = new HashMap();
    private HashMap<String, HashMap<String, MessageGroup>> moduleGroupsMap = new HashMap();

    protected MessageGroupsPool() {
    }

    public static MessageGroupsPool getInstance() {
        if (pool == null) {
            MessageGroupsPool.createMessageGroupsPool();
        }
        return pool;
    }

    public MessageGroup getMessageGroup(String moduleName, String name, Class type) {
        MessageGroup messageGroup = null;
        if (moduleName == null) {
            messageGroup = this.messageGroups.get(name);
        } else {
            HashMap<String, Object> moduleMessageGroups = this.moduleGroupsMap.get(moduleName);
            if (moduleMessageGroups == null) {
                moduleMessageGroups = new HashMap();
                this.moduleGroupsMap.put(moduleName, moduleMessageGroups);
            } else {
                messageGroup = moduleMessageGroups.get(name);
            }
        }
        if (messageGroup == null) {
            messageGroup = this.createMessageGroup(moduleName, name, type);
        }
        return messageGroup;
    }

    public void registerMessageGroup(String moduleName, Class type, Class messageGroupType) {
        HashMap<Class<Object>, Class<Object>> moduleMessageGroups = this.moduleClassesMap.get(moduleName);
        if (moduleMessageGroups == null) {
            moduleMessageGroups = new HashMap();
            this.moduleClassesMap.put(moduleName, moduleMessageGroups);
        }
        moduleMessageGroups.put(type, messageGroupType);
    }

    private MessageGroup createMessageGroup(String moduleName, String name, Class type) {
        MessageGroup messageGroup;
        HashMap<Class, Class> moduleMessageClasses = this.moduleClassesMap.get(moduleName);
        Class messageGroupClass = null;
        if (moduleMessageClasses != null && type != null) {
            messageGroupClass = moduleMessageClasses.get(type);
        }
        if (messageGroupClass == null && type != null) {
            messageGroupClass = this.messageGroupClasses.get(type);
        }
        if ((messageGroup = messageGroupClass == null ? this.defaultGroup : this.createGroup(name, moduleName, messageGroupClass)) != null) {
            if (moduleName == null) {
                this.messageGroups.put(name, messageGroup);
            } else {
                this.moduleGroupsMap.get(moduleName).put(name, messageGroup);
            }
        }
        return messageGroup;
    }

    protected MessageGroup createGroup(String name, String moduleName, Class messageGroupClass) {
        MessageGroup messageGroup;
        try {
            Constructor constructor = messageGroupClass.getConstructor(String.class);
            messageGroup = (MessageGroup)constructor.newInstance(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            messageGroup = this.defaultGroup;
        }
        return messageGroup;
    }

    private static void createMessageGroupsPool() {
        try {
            String classname = System.getProperty(MESSAGE_GROUPS_POOL_KEY);
            Class<?> clazz = Class.forName(classname, true, MessageGroupsPool.class.getClassLoader());
            pool = (MessageGroupsPool)clazz.newInstance();
        }
        catch (Throwable e) {
            pool = new MessageGroupsPool();
        }
    }
}

