/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.message;

import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.message.E2EBuilderMessage;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.util.StringTools;
import java.util.Date;
import java.util.Map;

public class E2EBuilderErrorMessage
extends E2EBuilderMessage {
    private BuilderError error;

    public E2EBuilderErrorMessage(Object source, BuilderError error, String type, String module) {
        super(source, error.getCode(), error.getParameter(), type, module);
        this.error = error;
        if (error.getTime() > 0L) {
            this.setDate(new Date(error.getTime()));
        }
    }

    @Override
    protected String getParameterizedMessage(String message) {
        message = super.getParameterizedMessage(message);
        Map<String, String> parameter = this.error.getTypeParameter();
        parameter.put("message", message);
        message = E2EBuilderTranslator.getModuleTranslation(this.getModule(), this.error.getTypeCode() + ".short", message);
        message = StringTools.replaceProperties((String)message, parameter);
        return message;
    }

    public String getErrorMessage() {
        return this.getParameterizedMessage(E2EBuilderTranslator.getModuleTranslation(this.getModule(), this.getCode() + ".short", this.getCode()));
    }

    public BuilderError getError() {
        return this.error;
    }
}

