/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.jms.JMSConnectionPool;
import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.PoolConfig;
import ch.e2e.bridge.server.jms.impl.ConnectionAdapter;
import ch.e2e.bridge.server.jms.impl.IAction;
import ch.e2e.bridge.server.jms.impl.JMSConnectionAdapterFactory;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import java.util.ArrayList;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

public class ConnectionAdapterPool
extends JMSConnectionPool {
    private static ConnectionAdapterPool adapterPool;
    private ArrayList<IAction> actions;
    private final JMSConnectionAdapterFactory connectionFactory;

    private ConnectionAdapterPool(JMSConnectionAdapterFactory connectionFactory) {
        super((KeyedPoolableObjectFactory<JMSSessionParameter, ConnectionAdapter>)connectionFactory);
        JMSLogger.getInstance().debug("15", "ConnectionAdapterPool.<init>");
        this.connectionFactory = connectionFactory;
        this.actions = new ArrayList();
    }

    public static ConnectionAdapterPool getInstance() {
        if (adapterPool == null) {
            adapterPool = new ConnectionAdapterPool(new JMSConnectionAdapterFactory());
        }
        return adapterPool;
    }

    public void setConnectionPoolConfig(PoolConfig poolConfig) {
        JMSLogger.getInstance().debug("15", "ConnectionAdapterPool.setConnectionPoolConfig: poolConfig = " + poolConfig);
        this.setMaxTotal(poolConfig.getMaxTotal());
        this.setMinIdle(poolConfig.getMinIdle());
        this.setMaxIdle(poolConfig.getMaxIdle());
        this.setMinEvictableIdleTimeMillis(poolConfig.getMinEvictableIdleTimeMillis());
        this.setTimeBetweenEvictionRunsMillis(poolConfig.getTimeBetweenEvictionRunsMillis());
        this.setNumTestsPerEvictionRun(poolConfig.getNumTestsPerEvictionRun());
        this.setMaxWait(poolConfig.getMaxWaitSec() > 0L ? poolConfig.getMaxWaitSec() * 1000L : poolConfig.getMaxWaitSec());
    }

    public void setSessionPoolConfig(PoolConfig sessionPoolConfig) {
        ConnectionAdapterPool.getInstance().connectionFactory.setSessionPoolConfig(sessionPoolConfig);
    }

    public void shutdown() {
        for (IAction action : this.actions) {
            try {
                action.shutdown();
            }
            catch (Exception e) {
                JMSLogger.getInstance().debug("21", "Shutdown failed: " + e);
            }
        }
        this.actions.clear();
        this.clear();
    }

    public void registerAction(IAction action) {
        this.actions.add(action);
    }

    public void unregisterAction(IAction action) {
        this.actions.remove(action);
    }
}

