/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server;

import ch.e2e.bridge.server.BridgeException;
import ch.e2e.bridge.server.JavaVirtualMachine;
import ch.e2e.bridge.server.Request;
import ch.e2e.bridge.server.ServerLogger;
import ch.e2e.bridge.server.dataitem.ItemFactory;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.session.Session;
import ch.e2e.bridge.server.session.SessionPool;
import ch.e2e.util.VersionChecker;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;

public abstract class JavaAddOn {
    private Request request;
    private String name;

    public JavaAddOn(String name) {
        this.name = name;
        if (!VersionChecker.checkVersion((String)"5.1.81.0", (String)JavaVirtualMachine.getRuntimeVersion())) {
            this.initialize();
            this.start();
        }
    }

    public final boolean initialize() {
        ArrayList<String> initializeErrors = new ArrayList<String>();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            this.request = JavaVirtualMachine.getExecutables().get(this.name);
            this.initialize(this.name, this.request, initializeErrors);
        }
        finally {
            JavaVirtualMachine.printAllInitializeErrors(this.getClass(), this.name, initializeErrors);
        }
        return initializeErrors.size() == 0;
    }

    public final void start() {
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        this.doStart();
    }

    protected void doStart() {
    }

    public final void stop() {
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        this.doStop();
    }

    protected void doStop() {
    }

    public static void setConfiguration(String file) {
        JavaVirtualMachine.setConfiguration(file);
    }

    public static void setConfiguration(String repositoryPath, String file) {
        JavaVirtualMachine.setConfiguration(repositoryPath, file);
    }

    public static void setConfiguration(File file) {
        JavaVirtualMachine.setConfiguration(file);
    }

    public final String getName() {
        return this.request.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean execute(long nativeSession, long nativeInputItem, long nativeOutputItem) {
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        boolean result = false;
        Session session = SessionPool.getInstance().getSession(nativeSession);
        RecordItem inputItem = ItemFactory.createRecordItem(nativeInputItem, session);
        RecordItem outputItem = ItemFactory.createRecordItem(nativeOutputItem, session);
        try {
            session.logEnter(4L, true, "JAVA", "JavaAddOn.execute", "start");
            result = this.execute(inputItem, outputItem, session);
        }
        catch (BridgeException e) {
            this.doErrorHandling(e, session);
        }
        catch (Throwable t) {
            this.doErrorHandling(t, session);
        }
        finally {
            session.logExit(4L, result, "JAVA", "JavaAddOn.execute", "executed");
            SessionPool.getInstance().getSession(nativeSession).clear();
        }
        return result;
    }

    protected void doErrorHandling(BridgeException e, Session session) {
        this.doErrorHandling(e, session, e.getCode());
    }

    protected void doErrorHandling(BridgeException e, Session session, String code) {
        this.doErrorHandling(e, session, code, Objects.toString(e.getDomain(), this.getClass().getPackage().getName()));
    }

    protected void doErrorHandling(Throwable t, Session session) {
        this.doErrorHandling(t, session, t.getClass().getName());
    }

    protected void doErrorHandling(Throwable t, Session session, String code) {
        this.doErrorHandling(t, session, code, this.getClass().getPackage().getName());
    }

    protected void doErrorHandling(Throwable t, Session session, String code, String domain) {
        this.printStackTrace(t, code);
        this.addError(session, t, code, domain);
    }

    private void addError(Session session, Throwable t, String code, String domain) {
        session.addError("External", domain, code, this.buildErrorMessage(t));
    }

    private String buildErrorMessage(Throwable t) {
        StringBuilder messageBuilder = new StringBuilder(Objects.toString(t.getMessage(), t.getClass().getName()));
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            messageBuilder.append("-->").append(cause.getMessage());
        }
        return messageBuilder.toString();
    }

    protected void printStackTrace(Throwable t, String code) {
        ServerLogger.getInstance().debug(code, t);
    }

    public abstract boolean execute(RecordItem var1, RecordItem var2, Session var3) throws Exception;

    protected abstract void initialize(String var1, Request var2, ArrayList<String> var3);

    public final void releaseCommit(long nativeSession) {
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        SessionPool.getInstance().commitSession(nativeSession);
    }

    public final void releaseRollback(long nativeSession) {
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        SessionPool.getInstance().rollbackSession(nativeSession);
    }

    public final void shutdown() {
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        JavaVirtualMachine.shutdown = true;
        this.doShutDown();
    }

    protected void doShutDown() {
    }
}

