/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.dom.DomUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StateObjectDetailsDialog
extends E2EBuilderDialog {
    private static final String XPATH_OBJECT = "PState/Object";
    private static final String XPATH_OBJECT_DATA = "PState/Object/Data";
    private static final String XPATH_OBJECT_STATES = "PState/Object/States/State";
    private static final String XPATH_OBJECT_EVENTS = "PState/Object/Events/Event";
    private static XPathExpression objectExpression;
    private static XPathExpression dataExpression;
    private static XPathExpression stateExpression;
    private static XPathExpression eventExpression;
    private JLabel objectId;
    private JLabel primaryKey;
    private JLabel owner;
    private JLabel isValid;
    private JTextArea dataField;
    private StatesTableModel statesTableModel;
    private EventsTableModel eventsTableModel;

    public StateObjectDetailsDialog(E2EBuilderModule module) {
        super(module.getTranslation("pstate.object.details.title"), module.getTranslation("pstate.object.details.internaltitle"), module.getTranslation("pstate.object.details.subtitle"), 1);
        this.createGui(module);
    }

    public void showDetails(Document objectDoc) {
        try {
            this.setObjectInfo(objectDoc);
            this.statesTableModel.states.clear();
            NodeList states = (NodeList)stateExpression.evaluate(objectDoc, XPathConstants.NODESET);
            int length = states.getLength();
            for (int i = 0; i < length; ++i) {
                this.statesTableModel.states.add(new State((Element)states.item(i)));
            }
            this.eventsTableModel.events.clear();
            NodeList events = (NodeList)eventExpression.evaluate(objectDoc, XPathConstants.NODESET);
            length = events.getLength();
            for (int i = 0; i < length; ++i) {
                this.eventsTableModel.events.add(new Event((Element)events.item(i)));
            }
            this.setData(objectDoc);
            this.showDialog();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setObjectInfo(Document objectDoc) throws XPathExpressionException {
        Element object = (Element)objectExpression.evaluate(objectDoc, XPathConstants.NODE);
        this.objectId.setText(DomUtilities.getTextValue((Element)object, (String)"Id", (String)""));
        this.primaryKey.setText(DomUtilities.getTextValue((Element)object, (String)"Name", (String)""));
        this.owner.setText(DomUtilities.getTextValue((Element)object, (String)"Owner", (String)""));
        this.isValid.setText(DomUtilities.getTextValue((Element)object, (String)"IsValid", (String)""));
    }

    private void setData(Document objectDoc) throws XPathExpressionException, TransformerException {
        Element dataElement = (Element)dataExpression.evaluate(objectDoc, XPathConstants.NODE);
        StringWriter dataWriter = new StringWriter();
        DomUtilities.serialize((Writer)dataWriter, (Node)dataElement, (boolean)true);
        String data = dataWriter.toString();
        int index = data.indexOf(62);
        index = data.indexOf(60, index);
        data = data.substring(index);
        this.dataField.setText(data);
    }

    private void createGui(E2EBuilderModule module) {
        this.addObjectInfo(module);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(1, 3, 1, 3);
        JPanel statesPanel = new JPanel(new BorderLayout());
        statesPanel.setBorder(new TitledBorder(module.getTranslation("pstate.object.details.states.border.title")));
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.setBorder(new EmptyBorder(5, 1, 8, 1));
        this.statesTableModel = new StatesTableModel(module);
        tablePanel.add(new JScrollPane(new JTable(this.statesTableModel), 20, 30));
        statesPanel.add(tablePanel);
        c.ipady = 10;
        centerPanel.add((Component)statesPanel, c);
        JPanel eventsPanel = new JPanel(new BorderLayout());
        eventsPanel.setBorder(new TitledBorder(module.getTranslation("pstate.object.details.events.border.title")));
        tablePanel = new JPanel(new BorderLayout());
        tablePanel.setBorder(new EmptyBorder(5, 1, 8, 1));
        this.eventsTableModel = new EventsTableModel(module);
        tablePanel.add(new JScrollPane(new JTable(this.eventsTableModel), 20, 30));
        eventsPanel.add(tablePanel);
        c.ipady = 10;
        centerPanel.add((Component)eventsPanel, c);
        c.ipady = 0;
        JPanel dataPanel = new JPanel(new BorderLayout());
        dataPanel.setBorder(new TitledBorder(module.getTranslation("pstate.object.details.data.border.title")));
        this.dataField = new JTextArea();
        this.dataField.setEditable(false);
        dataPanel.add(new JScrollPane(this.dataField, 20, 30));
        c.fill = 1;
        c.weighty = 1.0;
        centerPanel.add((Component)dataPanel, c);
        this.add(centerPanel, "Center");
    }

    private void addObjectInfo(E2EBuilderModule module) {
        JPanel north = new JPanel(new FlowLayout(0));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 3, 1, 3);
        JPanel objectInfo = new JPanel(new GridBagLayout());
        JLabel objectIdTitle = ComponentFactory.createLabel((String)"pstate.object.details.id", (E2EBuilderModule)module);
        objectIdTitle.setFont(objectIdTitle.getFont().deriveFont(1));
        objectInfo.add((Component)objectIdTitle, c);
        this.objectId = new JLabel("");
        c.gridwidth = 0;
        objectInfo.add((Component)this.objectId, c);
        JLabel primaryKeyTitle = ComponentFactory.createLabel((String)"pstate.object.details.primary.key", (E2EBuilderModule)module);
        primaryKeyTitle.setFont(objectIdTitle.getFont().deriveFont(1));
        c.gridwidth = 1;
        objectInfo.add((Component)primaryKeyTitle, c);
        this.primaryKey = new JLabel("");
        c.gridwidth = 0;
        objectInfo.add((Component)this.primaryKey, c);
        JLabel ownerTitle = ComponentFactory.createLabel((String)"pstate.object.details.owner", (E2EBuilderModule)module);
        ownerTitle.setFont(objectIdTitle.getFont().deriveFont(1));
        c.gridwidth = 1;
        objectInfo.add((Component)ownerTitle, c);
        this.owner = new JLabel("");
        c.gridwidth = 0;
        objectInfo.add((Component)this.owner, c);
        JLabel isValidTitle = ComponentFactory.createLabel((String)"pstate.object.details.is.valid", (E2EBuilderModule)module);
        isValidTitle.setFont(objectIdTitle.getFont().deriveFont(1));
        c.gridwidth = 1;
        objectInfo.add((Component)isValidTitle, c);
        this.isValid = new JLabel("");
        c.gridwidth = 0;
        objectInfo.add((Component)this.isValid, c);
        north.add((Component)objectInfo, c);
        this.add(north, "North");
    }

    public int getMinimumWidth() {
        return 800;
    }

    static {
        try {
            XPath xpath = DomUtilities.newXPath();
            objectExpression = xpath.compile(XPATH_OBJECT);
            dataExpression = xpath.compile(XPATH_OBJECT_DATA);
            stateExpression = xpath.compile(XPATH_OBJECT_STATES);
            eventExpression = xpath.compile(XPATH_OBJECT_EVENTS);
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    private class EventsTableModel
    implements TableModel {
        private ArrayList<Event> events = new ArrayList();
        private String nameHeader;
        private String idHeader;
        private String typeHeader;
        private String creationHeader;
        private String deliveryHeader;
        private String trialsHeader;

        public EventsTableModel(E2EBuilderModule module) {
            this.nameHeader = module.getTranslation("pstate.object.details.events.table.header.name");
            this.idHeader = module.getTranslation("pstate.object.details.events.table.header.id");
            this.typeHeader = module.getTranslation("pstate.object.details.events.table.header.type");
            this.creationHeader = module.getTranslation("pstate.object.details.events.table.header.creation.time");
            this.deliveryHeader = module.getTranslation("pstate.object.details.events.table.header.delivery.time");
            this.trialsHeader = module.getTranslation("pstate.object.details.events.table.header.delivery.trials");
        }

        @Override
        public int getRowCount() {
            return this.events.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = this.nameHeader;
                    break;
                }
                case 1: {
                    result = this.idHeader;
                    break;
                }
                case 2: {
                    result = this.typeHeader;
                    break;
                }
                case 3: {
                    result = this.creationHeader;
                    break;
                }
                case 4: {
                    result = this.deliveryHeader;
                    break;
                }
                case 5: {
                    result = this.trialsHeader;
                }
            }
            return result;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class result = null;
            switch (columnIndex) {
                case 0: {
                    result = String.class;
                    break;
                }
                case 1: {
                    result = String.class;
                    break;
                }
                case 2: {
                    result = String.class;
                    break;
                }
                case 3: {
                    result = String.class;
                    break;
                }
                case 4: {
                    result = String.class;
                    break;
                }
                case 5: {
                    result = Integer.class;
                }
            }
            return result;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object result = null;
            switch (columnIndex) {
                case 0: {
                    result = this.events.get(rowIndex).name;
                    break;
                }
                case 1: {
                    result = this.events.get(rowIndex).id;
                    break;
                }
                case 2: {
                    result = this.events.get(rowIndex).type;
                    break;
                }
                case 3: {
                    result = this.events.get(rowIndex).creationTime;
                    break;
                }
                case 4: {
                    result = this.events.get(rowIndex).deliveryTime;
                    break;
                }
                case 5: {
                    result = this.events.get(rowIndex).deliveryTrials;
                }
            }
            return result;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }

    private class Event {
        private String name;
        private String id;
        private String type;
        private String creationTime;
        private String deliveryTime;
        private int deliveryTrials;

        private Event(Element stateElement) {
            this.name = DomUtilities.getTextValue((Element)stateElement, (String)"Name", (String)"");
            int index = this.name.indexOf("...");
            if (index != -1) {
                this.name = this.name.substring(0, index);
            }
            this.id = DomUtilities.getTextValue((Element)stateElement, (String)"Id", (String)"");
            this.type = DomUtilities.getTextValue((Element)stateElement, (String)"Type", (String)"");
            this.creationTime = DomUtilities.getTextValue((Element)stateElement, (String)"Creation", (String)"");
            this.deliveryTime = DomUtilities.getTextValue((Element)stateElement, (String)"Delivery", (String)"");
            this.deliveryTrials = DomUtilities.getInt((Element)stateElement, (String)"DeliveryTrials", (int)0);
        }
    }

    private class StatesTableModel
    implements TableModel {
        private ArrayList<State> states = new ArrayList();
        private String nameHeader;
        private String tokenHeader;
        private String workingHeader;

        public StatesTableModel(E2EBuilderModule module) {
            this.nameHeader = module.getTranslation("pstate.object.details.states.table.header.name");
            this.tokenHeader = module.getTranslation("pstate.object.details.states.table.header.token");
            this.workingHeader = module.getTranslation("pstate.object.details.states.table.header.working");
        }

        @Override
        public int getRowCount() {
            return this.states.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = this.nameHeader;
                    break;
                }
                case 1: {
                    result = this.tokenHeader;
                    break;
                }
                case 2: {
                    result = this.workingHeader;
                }
            }
            return result;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<String> result = null;
            switch (columnIndex) {
                case 0: {
                    result = String.class;
                    break;
                }
                case 1: {
                    result = String.class;
                    break;
                }
                case 2: {
                    result = String.class;
                }
            }
            return result;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String result = null;
            switch (columnIndex) {
                case 0: {
                    result = this.states.get(rowIndex).name;
                    break;
                }
                case 1: {
                    result = this.states.get(rowIndex).token;
                    break;
                }
                case 2: {
                    result = this.states.get(rowIndex).working;
                }
            }
            return result;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }

    private class State {
        private String name;
        private String token;
        private String working;

        private State(Element stateElement) {
            this.name = DomUtilities.getTextValue((Element)stateElement, (String)"Name", (String)"");
            int index = this.name.indexOf("...");
            if (index != -1) {
                this.name = this.name.substring(0, index);
            }
            this.token = DomUtilities.getTextValue((Element)stateElement, (String)"Token", (String)"");
            this.working = DomUtilities.getTextValue((Element)stateElement, (String)"AtWork", (String)"false");
        }
    }
}

