/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.renderer;

import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.EditorContainer;
import ch.e2e.swing.renderer.RendererPreferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class CellEditor
implements TreeCellEditor,
TreeSelectionListener,
FocusListener {
    protected TreeCellEditor defaultEditor;
    private EditorContainer editingContainer;
    private Component editingComponent;
    private int offset;
    protected Tree tree;
    protected TreePath lastPath;
    private int lastRow;
    private Color borderSelectionColor;
    private Icon editingIcon;
    private Font font;
    private RendererPreferences preferences;
    private EventListenerList editorListenerList = new EventListenerList();
    private TreeCellEditor delegate;

    public CellEditor(Tree tree, RendererPreferences preferences) {
        this(tree, preferences, null);
    }

    public CellEditor(Tree tree, RendererPreferences preferences, TreeCellEditor defaultEditor) {
        this.preferences = preferences;
        this.defaultEditor = defaultEditor;
        if (this.defaultEditor == null) {
            this.defaultEditor = this.createDefaultEditor();
        }
        this.editingContainer = this.createDefaultContainer();
        this.setTree(tree);
        this.setBorderSelectionColor(UIManager.getColor("Tree.editorBorderSelectionColor"));
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.setTree(tree);
        this.lastRow = row;
        this.determineOffset(tree, value, isSelected, expanded, leaf, row);
        if (this.editingComponent != null) {
            this.editingContainer.removeEditor(this.editingComponent);
        }
        this.setDelegate(((Tree)tree).getEditor(value.getClass()));
        if (this.delegate == null) {
            this.setDelegate(this.defaultEditor);
        }
        this.editingComponent = this.delegate.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        this.editingComponent.addFocusListener(this);
        Font font = this.getFont();
        if (font == null) {
            font = tree.getFont();
        }
        this.editingContainer.setFont(font);
        this.prepareForEditing();
        return this.editingContainer.getContainerComponent(tree, value, isSelected, expanded, leaf, row);
    }

    @Override
    public Object getCellEditorValue() {
        Object result = null;
        if (this.delegate != null) {
            result = this.delegate.getCellEditorValue();
        }
        return result;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        Object node;
        boolean result = false;
        TreePath path = null;
        if (event == null) {
            path = this.lastPath;
        } else if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event) && event.getSource() instanceof JTree && this.defaultEditor.isCellEditable(event)) {
            path = this.tree.getPathForLocation(((MouseEvent)event).getX(), ((MouseEvent)event).getY());
        }
        if (path != null && (node = path.getLastPathComponent()) != null && ((AbstractTreeModel)this.tree.getModel()).isEditable(node) && (this.lastPath != null && this.lastPath.equals(path) || this.canEditImmediately(event))) {
            this.prepareForEditing();
            result = true;
        }
        return result;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return this.delegate.shouldSelectCell(event);
    }

    @Override
    public boolean stopCellEditing() {
        boolean result = false;
        if (this.delegate.stopCellEditing()) {
            this.cleanupAfterEditing();
            result = true;
        }
        return result;
    }

    @Override
    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
        this.cleanupAfterEditing();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.editorListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.editorListenerList.remove(CellEditorListener.class, l);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return (CellEditorListener[])this.editorListenerList.getListeners(CellEditorListener.class);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.tree != null) {
            this.lastPath = this.tree.getSelectionCount() == 1 ? this.tree.getSelectionPath() : null;
        }
    }

    protected void setDelegate(TreeCellEditor cellEditor) {
        this.removeDelegateCellEditorListeners();
        this.delegate = cellEditor;
        this.addDelegateCellEditorListeners();
    }

    private void addDelegateCellEditorListeners() {
        if (this.delegate != null) {
            for (CellEditorListener listener : this.getCellEditorListeners()) {
                this.delegate.addCellEditorListener(listener);
            }
        }
    }

    private void removeDelegateCellEditorListeners() {
        if (this.delegate != null) {
            for (CellEditorListener listener : this.getCellEditorListeners()) {
                this.delegate.removeCellEditorListener(listener);
            }
        }
    }

    private void setTree(JTree tree) {
        if (tree != null && tree instanceof Tree && this.tree != tree) {
            if (this.tree != null) {
                this.tree.removeTreeSelectionListener(this);
            }
            this.tree = (Tree)tree;
            this.tree.addTreeSelectionListener(this);
        }
    }

    protected boolean canEditImmediately(EventObject event) {
        if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            MouseEvent me = (MouseEvent)event;
            return me.getClickCount() > 2 && this.inHitRegion(me.getX(), me.getY());
        }
        return event == null;
    }

    protected boolean inHitRegion(int x, int y) {
        Rectangle bounds;
        return this.lastRow == -1 || this.tree == null || (bounds = this.tree.getRowBounds(this.lastRow)) == null || x > bounds.x + this.offset || this.offset >= bounds.width - 5;
    }

    protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (this.preferences != null) {
            this.editingIcon = this.preferences.getEditingIcon(value, leaf, expanded);
            this.offset = this.editingIcon != null ? this.editingIcon.getIconWidth() : 0;
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    protected void prepareForEditing() {
        if (this.editingComponent != null) {
            this.editingContainer.addEditor(this.editingComponent);
        }
    }

    public void setEditorContainer(EditorContainer editorContainer) {
        this.editingContainer = editorContainer;
    }

    protected EditorContainer createDefaultContainer() {
        return new DefaultContainer();
    }

    protected TreeCellEditor createDefaultEditor() {
        Border aBorder = UIManager.getBorder("Tree.editorBorder");
        DefaultCellEditor editor = new DefaultCellEditor(new DefaultTextField(aBorder));
        editor.setClickCountToStart(1);
        return editor;
    }

    private void cleanupAfterEditing() {
        if (this.editingComponent != null) {
            this.editingContainer.removeEditor(this.editingComponent);
            this.editingComponent.removeFocusListener(this);
        }
        this.editingComponent = null;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.stopCellEditing();
    }

    public class DefaultContainer
    extends Container
    implements EditorContainer {
        public DefaultContainer() {
            this.setLayout(null);
        }

        @Override
        public void paint(Graphics g) {
            Color background;
            Dimension size = this.getSize();
            if (CellEditor.this.editingIcon != null) {
                int yLoc = Math.max(0, (this.getSize().height - CellEditor.this.editingIcon.getIconHeight()) / 2);
                CellEditor.this.editingIcon.paintIcon(this, g, 0, yLoc);
            }
            if ((background = CellEditor.this.getBorderSelectionColor()) != null) {
                g.setColor(background);
                g.drawRect(0, 0, size.width - 1, size.height - 1);
            }
            super.paint(g);
        }

        @Override
        public void doLayout() {
            if (CellEditor.this.editingComponent != null) {
                Dimension cSize = this.getSize();
                CellEditor.this.editingComponent.getPreferredSize();
                CellEditor.this.editingComponent.setLocation(CellEditor.this.offset, 0);
                CellEditor.this.editingComponent.setBounds(CellEditor.this.offset, 0, cSize.width - CellEditor.this.offset, cSize.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (CellEditor.this.editingComponent != null) {
                Dimension pSize = CellEditor.this.editingComponent.getPreferredSize();
                pSize.width += CellEditor.this.offset + 5;
                if (CellEditor.this.editingIcon != null) {
                    pSize.height = Math.max(pSize.height, CellEditor.this.editingIcon.getIconHeight());
                }
                pSize.width = Math.max(pSize.width, 100);
                return pSize;
            }
            return new Dimension(0, 0);
        }

        @Override
        public void addEditor(Component editorComponent) {
            this.add(CellEditor.this.editingComponent);
        }

        @Override
        public void removeEditor(Component editorComponent) {
            this.remove(CellEditor.this.editingComponent);
        }

        @Override
        public Component getContainerComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            return this;
        }
    }

    public class DefaultTextField
    extends JTextField {
        protected Border border;

        public DefaultTextField(Border border) {
            super(40);
            this.setBorder(border);
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(border);
            this.border = border;
        }

        @Override
        public Border getBorder() {
            return this.border;
        }

        @Override
        public Font getFont() {
            Container parent;
            Font font = super.getFont();
            if (font instanceof FontUIResource && (parent = this.getParent()) != null && parent.getFont() != null) {
                font = parent.getFont();
            }
            return font;
        }
    }
}

