/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.swing.MouseOverButton;
import ch.e2e.swing.border.SmallBevelBorder;
import ch.e2e.swing.filechooser.DirectoryButtonPanel;
import ch.e2e.swing.filechooser.FileChooserConstants;
import ch.e2e.swing.model.Directory;
import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class BigDirectoryButtonPanel
extends DirectoryButtonPanel {
    private MouseOverButton homeButton;
    private MouseOverButton desktopButton;

    public BigDirectoryButtonPanel() {
        super(1);
        this.createGui();
    }

    @Override
    protected void selectDirectory(Directory selectedDirectory) {
        if (selectedDirectory.getDir() != null && this.desktopButton != null) {
            this.desktopButton.setPressed(selectedDirectory.getDir().equals(FileChooserConstants.DESKTOP));
            this.homeButton.setPressed(selectedDirectory.getDir().equals(FileChooserConstants.USER_HOME));
        }
    }

    private void createGui() {
        this.setBackground(new Color(153, 153, 153));
        this.setBorder(new CompoundBorder(new SmallBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        if (FileChooserConstants.DESKTOP != null) {
            this.desktopButton = this.addButton((Icon)folderDesktopBigIcon, FileChooserConstants.DESKTOP, false);
        }
        this.homeButton = this.addButton((Icon)folderHomeBigIcon, FileChooserConstants.USER_HOME, false);
        ((GridLayout)this.buttonPanel.getLayout()).setHgap(5);
        ((GridLayout)this.buttonPanel.getLayout()).setVgap(5);
    }
}

